<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>

<div class="modernpress-heading-container modernpress-heading-layout-1">
    <?php if (!empty($settings['subtitle'])): ?>
        <div><span class="modernpress-heading-subtitle"><?php echo esc_html($settings['subtitle']); ?></span></div>
    <?php endif; ?>
    
    <?php if (!empty($settings['title'])): ?>
        <<?php echo esc_attr($settings['title_tag']); ?> class="modernpress-heading-title">
            <?php echo esc_html($settings['title']); ?>
        </<?php echo esc_attr($settings['title_tag']); ?>>
    <?php endif; ?>
    
    <?php if (!empty($settings['description'])): ?>
        <div class="modernpress-heading-description">
            <?php echo wp_kses_post($settings['description']); ?>
        </div>
    <?php endif; ?>
</div>