<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$gallery_items = $settings['gallery_items'];
$enable_lightbox = $settings['enable_lightbox'] === 'yes';
$lightbox_animation = $settings['lightbox_animation'];
?>

<div class="modernpress-gallery modernpress-gallery-layout-6">
    <div class="gallery-grid">
        <?php foreach ($gallery_items as $index => $item): ?>
            <div class="gallery-item" data-index="<?php echo esc_attr($index); ?>">
                <div class="gallery-item-inner">
                    <?php
                    $image_url = !empty($item['image']['url']) ? $item['image']['url'] : $this->default_image;
                    $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                    $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                    $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>

                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($image_url); ?>" class="gallery-lightbox" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($this->get_id()); ?>"
                            data-elementor-lightbox-title="<?php echo esc_attr($item['title']); ?>">
                        <?php endif; ?>

                        <div class="gallery-item-image">
                            <?php
                            // Use Elementor's methods to render the image
                            echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'image'));
                            ?>
                        </div>

                        <div class="gallery-item-overlay">
                            <div class="overlay-content">
                                <?php if ($item['title']): ?>
                                    <h3 class="gallery-item-title"><?php echo esc_html($item['title']); ?></h3>
                                <?php endif; ?>

                                <?php if ($item['category']): ?>
                                    <span class="gallery-item-category"><?php echo esc_html($item['category']); ?></span>
                                <?php endif; ?>

                                <?php if ($enable_lightbox): ?>
                                    <div class="lightbox-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 3h6v6M9 21H3v-6M21 3l-7 7M3 21l7-7" stroke="currentColor"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                <?php elseif ($link_url): ?>
                                    <a href="<?php echo esc_url($link_url); ?>" class="gallery-item-link" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>
                                        <span>View Project</span>
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if ($enable_lightbox): ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>