<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$gallery_items = $settings['gallery_items'];
$enable_lightbox = $settings['enable_lightbox'] === 'yes';
$lightbox_animation = $settings['lightbox_animation'];

// Extract unique categories
$categories = array_unique(array_filter(array_map(function ($item) {
    return !empty($item['category']) ? $item['category'] : '';
}, $gallery_items)));
?>

<div class="modernpress-gallery modernpress-gallery-layout-5">
    <div class="filter-container">
        <button class="filter-button active" data-filter="all">All</button>
        <?php foreach ($categories as $category): ?>
            <button class="filter-button" data-filter="<?php echo esc_attr($category); ?>">
                <?php echo esc_html($category); ?>
            </button>
        <?php endforeach; ?>
    </div>

    <div class="gallery-grid">
        <?php foreach ($gallery_items as $item): ?>
            <div class="gallery-item" data-category="<?php echo esc_attr($item['category']); ?>">
                <div class="gallery-item-inner">
                    <?php
                    $image_url = !empty($item['image']['url']) ? $item['image']['url'] : $this->default_image;
                    $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                    $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                    $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>

                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($image_url); ?>" class="gallery-lightbox" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($this->get_id()); ?>"
                            data-elementor-lightbox-title="<?php echo esc_attr($item['title']); ?>"
                            data-category="<?php echo esc_attr($item['category']); ?>">
                        <?php elseif ($link_url): ?>
                            <a href="<?php echo esc_url($link_url); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>

                            <?php endif; ?>

                            <div class="gallery-item-image">
                                <?php
                                // Use Elementor's methods to render the image
                                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'image'));
                                ?>
                            </div>

                            <div class="gallery-item-overlay">
                                <?php if ($item['title']): ?>
                                    <h3 class="gallery-item-title"><?php echo esc_html($item['title']); ?></h3>
                                <?php endif; ?>

                                <?php if ($item['category']): ?>
                                    <span class="gallery-item-category"><?php echo esc_html($item['category']); ?></span>
                                <?php endif; ?>


                            </div>

                            <?php if ($enable_lightbox || $link_url): ?>
                            </a>
                        <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>