<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$gallery_items = $settings['gallery_items'];
$columns = $settings['columns'] ?? 3;
$gap = $settings['gap'] ?? '20px';
$enable_lightbox = $settings['enable_lightbox'] === 'yes';
$lightbox_animation = $settings['lightbox_animation'];
?>

<div class="modernpress-gallery modernpress-gallery-layout-3">
    <div class="metro-grid" style="--gap: <?php echo esc_attr($gap); ?>;">
        <?php foreach ($gallery_items as $index => $item):
            $grid_class = '';
            switch ($index % 7) {
                case 0:
                    $grid_class = 'wide tall';
                    break;
                case 1:
                case 2:
                    $grid_class = 'normal';
                    break;
                case 3:
                    $grid_class = 'tall';
                    break;
                case 4:
                    $grid_class = 'wide';
                    break;
                case 5:
                case 6:
                    $grid_class = 'normal';
                    break;
            }
            ?>
            <div class="gallery-item <?php echo esc_attr($grid_class); ?>" data-aos="fade-up"
                data-aos-delay="<?php echo esc_attr($index * 100); ?>">
                <div class="gallery-item-inner">
                    <?php
                    $image_url = !empty($item['image']['url']) ? $item['image']['url'] : $this->default_image;
                    $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                    $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                    $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>

                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($image_url); ?>" class="gallery-lightbox" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($this->get_id()); ?>"
                            data-elementor-lightbox-title="<?php echo esc_attr($item['title']); ?>">
                        <?php elseif ($link_url): ?>
                            <a href="<?php echo esc_url($link_url); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>

                            <?php endif; ?>

                            <div class="gallery-item-image">
                                <?php
                                // Use Elementor's methods to render the image
                                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'image'));
                                ?>
                            </div>

                            <div class="gallery-item-overlay">
                                <div class="overlay-background"></div>
                                <div class="overlay-content">
                                    <?php if ($item['title']): ?>
                                        <h3 class="gallery-item-title"><?php echo esc_html($item['title']); ?></h3>
                                    <?php endif; ?>

                                    <?php if ($item['category']): ?>
                                        <span class="gallery-item-category"><?php echo esc_html($item['category']); ?></span>
                                    <?php endif; ?>

                                    <span class="view-more">
                                        <?php if ($enable_lightbox): ?>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M15 3h6v6M9 21H3v-6M21 3l-7 7M3 21l7-7" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        <?php else: ?>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12 4V20M20 12H4" stroke="currentColor" stroke-width="2"
                                                    stroke-linecap="round" />
                                            </svg>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>

                            <?php if ($enable_lightbox || $link_url): ?>
                            </a>
                        <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>