<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$gallery_items = $settings['gallery_items'];
$columns = $settings['columns'] ?? 3;
$gap = $settings['gap'] ?? '20px';
$enable_lightbox = $settings['enable_lightbox'] === 'yes';
$lightbox_animation = $settings['lightbox_animation'];
?>

<div class="modernpress-gallery modernpress-gallery-layout-2">
    <div class="masonry-grid" style=" --gap: <?php echo esc_attr($gap); ?>;">
        <?php foreach ($gallery_items as $index => $item):
            $height_class = ($index % 3 === 0) ? 'tall' : (($index % 5 === 0) ? 'wide' : 'normal');
            ?>
            <div class="gallery-item <?php echo esc_attr($height_class); ?>">
                <div class="gallery-item-inner">
                    <?php
                    $image_url = !empty($item['image']['url']) ? $item['image']['url'] : $this->default_image;
                    $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                    $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                    $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>

                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($image_url); ?>" class="gallery-lightbox" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($this->get_id()); ?>"
                            data-elementor-lightbox-title="<?php echo esc_attr($item['title']); ?>">
                        <?php elseif ($link_url): ?>
                            <a href="<?php echo esc_url($link_url); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>

                            <?php endif; ?>

                            <div class="gallery-item-image">
                                <?php
                                // Use Elementor's methods to render the image
                                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'image'));
                                ?>
                            </div>

                            <div class="gallery-item-overlay">
                                <div class="overlay-content">
                                    <?php if ($item['title']): ?>
                                        <h3 class="gallery-item-title"><?php echo esc_html($item['title']); ?></h3>
                                    <?php endif; ?>

                                    <?php if ($item['category']): ?>
                                        <span class="gallery-item-category"><?php echo esc_html($item['category']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php if ($enable_lightbox || $link_url): ?>
                            </a>
                        <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>