<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$gallery_items = $settings['gallery_items'];
$columns = $settings['columns'];
$enable_lightbox = $settings['enable_lightbox'] === 'yes';
$lightbox_animation = $settings['lightbox_animation'];
?>

<div class="modernpress-gallery modernpress-gallery-layout-1">
    <div class="gallery-grid">
        <?php foreach ($gallery_items as $index => $item): ?>
            <div class="gallery-item">
                <div class="gallery-item-inner">
                    <?php
                    $image_url = !empty($item['image']['url']) ? $item['image']['url'] : $this->default_image;
                    $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                    $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                    $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>

                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($image_url); ?>" class="gallery-lightbox" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($this->get_id()); ?>"
                            data-elementor-lightbox-title="<?php echo esc_attr($item['title']); ?>">
                        <?php elseif ($link_url): ?>
                            <a href="<?php echo esc_url($link_url); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>

                            <?php endif; ?>

                            <div class="gallery-item-image">
                                <?php
                                // Use Elementor's methods to render the image
                                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'image'));
                                ?>
                            </div>

                            <div class="gallery-item-overlay">
                                <?php if ($item['title']): ?>
                                    <h3 class="gallery-item-title"><?php echo esc_html($item['title']); ?></h3>
                                <?php endif; ?>

                                <?php if ($item['category']): ?>
                                    <span class="gallery-item-category"><?php echo esc_html($item['category']); ?></span>
                                <?php endif; ?>
                            </div>

                            <?php if ($enable_lightbox || $link_url): ?>
                            </a>
                        <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>