<?php
if (!defined('ABSPATH')) {
    exit;
}

// Get button 1 settings
$btn1_tag = 'div';
$btn1_link_attr = '';
$btn1_classes = 'modernpress-cta-btn modernpress-cta-btn-secondary';

if (!empty($settings['btn1_link']['url'])) {
    $btn1_tag = 'a';
    $this->add_link_attributes('btn1_link', $settings['btn1_link']);
    $btn1_link_attr = $this->get_render_attribute_string('btn1_link');
}

// Get button 2 settings
$btn2_tag = 'div';
$btn2_link_attr = '';
$btn2_classes = 'modernpress-cta-btn modernpress-cta-btn-primary';

if (!empty($settings['btn2_link']['url'])) {
    $btn2_tag = 'a';
    $this->add_link_attributes('btn2_link', $settings['btn2_link']);
    $btn2_link_attr = $this->get_render_attribute_string('btn2_link');
}
?>

<div class="modernpress-cta-container modernpress-cta-layout-2">
    <div class="modernpress-cta-content-wrapper">
        <div class="modernpress-cta-content">
            <?php if (!empty($settings['heading'])) : ?>
                <h2 class="modernpress-cta-heading"><?php echo esc_html($settings['heading']); ?></h2>
            <?php endif; ?>

            <?php if (!empty($settings['description'])) : ?>
                <div class="modernpress-cta-description"><?php echo wp_kses_post($settings['description']); ?></div>
            <?php endif; ?>

            <div class="modernpress-cta-buttons">
                <?php if (!empty($settings['btn1_text'])) : ?>
                    <<?php echo esc_attr($btn1_tag); ?> class="<?php echo esc_attr($btn1_classes); ?>" <?php echo wp_kses_post($btn1_link_attr); ?>>
                        <?php echo esc_html($settings['btn1_text']); ?>
                    </<?php echo esc_attr($btn1_tag); ?>>
                <?php endif; ?>

                <?php if (!empty($settings['btn2_text'])) : ?>
                    <<?php echo esc_attr($btn2_tag); ?> class="<?php echo esc_attr($btn2_classes); ?>" <?php echo wp_kses_post($btn2_link_attr); ?>>
                        <?php echo esc_html($settings['btn2_text']); ?>
                    </<?php echo esc_attr($btn2_tag); ?>>
                <?php endif; ?>
            </div>
        </div>

        <div class="modernpress-cta-image-wrapper">
            <?php if (!empty($settings['image']['url'])) : ?>
                <div class="modernpress-cta-image">
                    <?php echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($settings, 'image')); ?>
                </div>
            <?php else : ?>
                <div class="modernpress-cta-placeholder-image">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                        <polyline points="21 15 16 10 5 21"></polyline>
                    </svg>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
