<?php
/**
 * ModernPress Content Block Widget - Layout 5 (Tabs Layout)
 * Modified structure with title/description in top row
 * Tabs on left column, image on right column
 * Added tab headings above descriptions
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$title = $settings['title'];
$description = $settings['description'];
$button_text = $settings['button_text'];
$button_link = $settings['button_link']['url'];
$button_target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
$button_nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
$image = $settings['image'];
$content_alignment = isset($settings['content_alignment']) ? $settings['content_alignment'] : 'left';

$items = isset($settings['items_layout5']) ? $settings['items_layout5'] : [];

// Generate a unique ID for this tabs instance
$tabs_id = 'modernpress-tabs-' . $this->get_id();

?>
<div class="modernpress-content-block-container layout-5">
    <div class="modernpress-content-block-wrapper">
        <!-- Title and Description Row -->
        <div class="modernpress-content-block-header" style="text-align: <?php echo esc_attr($content_alignment); ?>">
            <?php if (!empty($title)) : ?>
                <h2 class="modernpress-content-block-title"><?php echo wp_kses_post($title); ?></h2>
            <?php endif; ?>
            
            <?php if (!empty($description)) : ?>
                <div class="modernpress-content-block-description"><?php echo wp_kses_post($description); ?></div>
            <?php endif; ?>
        </div>
        
        <!-- Tabs and Image Row -->
        <div class="modernpress-content-block-row">
            <!-- Tabs Column - Left -->
            <div class="modernpress-content-block-col modernpress-content-block-tabs-content">
                <?php if (!empty($items)) : ?>
                    <div class="modernpress-tabs-container">
                        <!-- Tab Pills -->
                        <div class="modernpress-tabs-scroll-wrapper">
    <div class="modernpress-tabs-pills">
        <?php foreach ($items as $index => $item) : ?>
            <div class="modernpress-tab-pill <?php echo $index === 0 ? 'active' : ''; ?>" data-tab="<?php echo esc_attr($tabs_id . '-tab-' . $index); ?>">
                <?php echo wp_kses_post($item['item_title']); ?>
            </div>
        <?php endforeach; ?>
    </div>
</div>

                        
                        <!-- Tab Content -->
                        <div class="modernpress-tabs-content">
                            <?php foreach ($items as $index => $item) : ?>
                                <div id="<?php echo esc_attr($tabs_id . '-tab-' . $index); ?>" class="modernpress-tab-content <?php echo $index === 0 ? 'active' : ''; ?>">
                                    <?php if (!empty($item['item_heading'])) : ?>
                                        <h3 class="modernpress-tab-heading"><?php echo wp_kses_post($item['item_heading']); ?></h3>
                                    <?php endif; ?>
                                    <div class="modernpress-tab-description">
                                        <?php echo wp_kses_post($item['item_description']); ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($button_text)) : ?>
                    <div class="modernpress-content-block-button-container">
                    <a class="modernpress-content-block-btn" href="<?php echo esc_url($button_link); ?>"
   <?php echo $button_target ? ' target="' . esc_attr(trim($button_target, '"')) . '"' : ''; ?>
   <?php echo $button_nofollow ? ' rel="' . esc_attr(trim($button_nofollow, '"')) . '"' : ''; ?>>
    <?php echo esc_html($button_text); ?>

    <?php if ('yes' === $settings['show_button_icon'] && !empty($settings['button_icon']['value'])) : ?>
        <span class="btn-icon">
        <?php \Elementor\Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true']); ?>
        </span>
    <?php endif; ?>
</a>

                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Image Column - Right -->
            <div class="modernpress-content-block-col modernpress-content-block-image">
            <?php echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($settings, 'image')); ?>
            </div>
        </div>
    </div>
</div>

