<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Get button settings
$btn_tag = 'div';
$btn_link_attr = '';
$btn_classes = 'modernpress-content-block-btn';

if (!empty($settings['button_link']['url'])) {
    $btn_tag = 'a';
    $this->add_link_attributes('button_link', $settings['button_link']);
    $btn_link_attr = $this->get_render_attribute_string('button_link');
}

// Prepare button icon
$button_icon_html = '';
if ($settings['show_button_icon'] === 'yes' && !empty($settings['button_icon']['value'])) {
    ob_start();
    \Elementor\Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true', 'class' => 'btn-icon']);
    $button_icon_html = ob_get_clean();
}

// Get image position
$image_position = $settings['image_position'];
$container_class = 'modernpress-content-block-container modernpress-content-block-layout-3';
if ($image_position === 'left') {
    $container_class .= ' image-left';
} else {
    $container_class .= ' image-right';
}
?>

<div class="<?php echo esc_attr($container_class); ?>">
    <?php if (!empty($settings['title'])) : ?>
        <div class="modernpress-content-block-header">
            <h3 class="modernpress-content-block-title"><?php echo esc_html($settings['title']); ?></h3>
        </div>
    <?php endif; ?>
    
    <div class="modernpress-content-block-wrapper">
        <div class="modernpress-content-block-text">
            <?php if (!empty($settings['description'])) : ?>
                <div class="modernpress-content-block-description"><?php echo wp_kses_post($settings['description']); ?></div>
            <?php endif; ?>

            <?php if (!empty($settings['button_text'])) : ?>
                <div class="modernpress-content-block-button-wrapper">
                    <<?php echo tag_escape($btn_tag); ?> class="<?php echo esc_attr($btn_classes); ?>" <?php echo wp_kses_post($btn_link_attr); ?>>
                        <?php echo esc_html($settings['button_text']); ?>
                        <?php if (!empty($button_icon_html)) : ?>
                            <span class="icon-wrapper"><?php echo wp_kses_post($button_icon_html); ?></span>
                        <?php endif; ?>
                    </<?php echo tag_escape($btn_tag); ?>>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="modernpress-content-block-image">
            <?php
            if (!empty($settings['image']['url'])) {
                echo wp_kses_post( \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'image' ) );

            } else {
                // Whitelist safe SVG output
                echo wp_kses(
                    '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>',
                    [
                        'svg'      => ['xmlns' => true, 'viewBox' => true, 'fill' => true, 'stroke' => true, 'stroke-width' => true, 'stroke-linecap' => true, 'stroke-linejoin' => true],
                        'rect'     => ['x' => true, 'y' => true, 'width' => true, 'height' => true, 'rx' => true, 'ry' => true],
                        'circle'   => ['cx' => true, 'cy' => true, 'r' => true],
                        'polyline' => ['points' => true],
                    ]
                );
            }
            ?>
        </div>
    </div>
</div>
