<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Get button settings
$btn_tag = 'div';
$btn_link_attr = '';
$btn_classes = 'modernpress-content-block-btn';

if (!empty($settings['button_link']['url'])) {
    $btn_tag = 'a';
    $this->add_link_attributes('button_link', $settings['button_link']);
    $btn_link_attr = $this->get_render_attribute_string('button_link');
}

// Prepare button icon
$button_icon_html = '';
if ($settings['show_button_icon'] === 'yes' && !empty($settings['button_icon']['value'])) {
    ob_start();
    \Elementor\Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true', 'class' => 'btn-icon']);
    $button_icon_html = ob_get_clean();
}
?>

<div class="modernpress-content-block-container modernpress-content-block-layout-2">
    <div class="modernpress-content-block-wrapper">
        <div class="modernpress-content-block-text">
            <?php if (!empty($settings['title'])) : ?>
                <h3 class="modernpress-content-block-title"><?php echo esc_html($settings['title']); ?></h3>
            <?php endif; ?>

            <?php if (!empty($settings['description'])) : ?>
                <div class="modernpress-content-block-description"><?php echo wp_kses_post($settings['description']); ?></div>
            <?php endif; ?>

            <?php if (!empty($settings['button_text'])) : ?>
                <div class="modernpress-content-block-button-wrapper">
                    <<?php echo tag_escape($btn_tag); ?> class="<?php echo esc_attr($btn_classes); ?>" <?php echo wp_kses_post($btn_link_attr); ?>>
                        <?php echo esc_html($settings['button_text']); ?>
                        <?php if (!empty($button_icon_html)) : ?>
                            <span class="icon-wrapper"><?php echo wp_kses_post($button_icon_html); ?></span>
                        <?php endif; ?>
                    </<?php echo tag_escape($btn_tag); ?>>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
