<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Get button settings
$btn_tag = 'div';
$btn_link_attr = '';
$btn_classes = 'modernpress-content-block-btn';

if (!empty($settings['button_link']['url'])) {
    $btn_tag = 'a';
    $this->add_link_attributes('button_link', $settings['button_link']);
    $btn_link_attr = $this->get_render_attribute_string('button_link');
}

// Image position class
$image_position_class = $settings['image_position'] === 'left' ? 'image-left' : 'image-right';

// Prepare button icon
$button_icon_html = '';
if ($settings['show_button_icon'] === 'yes' && !empty($settings['button_icon']['value'])) {
    ob_start();
    \Elementor\Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true', 'class' => 'btn-icon']);
    $button_icon_html = ob_get_clean();
}
?>

<div class="modernpress-content-block-container modernpress-content-block-layout-1 <?php echo esc_attr($image_position_class); ?>">
    <div class="modernpress-content-block-wrapper">
        <div class="modernpress-content-block-text">
            <?php if (!empty($settings['title'])) : ?>
                <h3 class="modernpress-content-block-title"><?php echo esc_html($settings['title']); ?></h3>
            <?php endif; ?>

            <?php if (!empty($settings['description'])) : ?>
                <div class="modernpress-content-block-description"><?php echo wp_kses_post($settings['description']); ?></div>
            <?php endif; ?>

            <?php if (!empty($settings['button_text'])) : ?>
                <<?php echo esc_html($btn_tag); ?> class="<?php echo esc_attr($btn_classes); ?>" <?php echo wp_kses_post($btn_link_attr); ?>>
                    <?php echo esc_html($settings['button_text']); ?>
                    <?php if (!empty($button_icon_html)) : ?>
                        <span class="icon-wrapper"><?php echo wp_kses_post($button_icon_html); ?></span>
                    <?php endif; ?>
                </<?php echo esc_html($btn_tag); ?>>
            <?php endif; ?>
        </div>

        <div class="modernpress-content-block-image">
            <?php 
            if (!empty($settings['image']['url'])) {
                echo wp_kses_post( \Elementor\Group_Control_Image_Size::get_attachment_image_html($settings, 'image') );

            } else {
                // Placeholder image
                echo '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>';
            }
            ?>
        </div>
    </div>
</div>
