<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$logos = $settings['logos'];
$desktop_columns = $this->get_settings('columns');
$tablet_columns = $this->get_settings('columns_tablet');
$mobile_columns = $this->get_settings('columns_mobile');
$hover_effect = $settings['logo_hover_effect'];
// Add custom CSS variables for responsive columns
$custom_css = "
    .modernpress-client-logos-layout-4 {
        --desktop-columns: {$desktop_columns};
        --tablet-columns: {$tablet_columns};
        --mobile-columns: {$mobile_columns};
    }
";

// Add the custom CSS inline
$this->add_inline_style($custom_css);
?>

<div <?php echo wp_kses_post($this->get_render_attribute_string('logos-container')); ?>>

    <div class="logos-grid">
        <?php foreach ($logos as $item): ?>
            <div class="logo-item">
                <?php
                $logo_url = !empty($item['logo']['url']) ? $item['logo']['url'] : $this->default_logo;
                $link_url = !empty($item['link']['url']) ? $item['link']['url'] : '';
                $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
                $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
                $grayscale_class = $item['grayscale'] === 'yes' ? 'grayscale' : '';
                $hover_class = 'hover-' . $hover_effect;
                ?>

                <?php if ($link_url): ?>
                    <a href="<?php echo esc_url($link_url); ?>" <?php echo esc_attr($target) . esc_attr($nofollow); ?>
                        class="client-logo <?php echo esc_attr($grayscale_class . ' ' . $hover_class); ?>">
                    <?php else: ?>
                        <div class="client-logo <?php echo esc_attr($grayscale_class . ' ' . $hover_class); ?>">
                        <?php endif; ?>

                        <div class="logo-wrapper">
                            <?php
                            // Use Elementor's methods to render the image
                            echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'logo'));
                            ?>
                            <?php if ($item['company_name']): ?>
                                <span class="company-name"><?php echo esc_html($item['company_name']); ?></span>
                            <?php endif; ?>
                        </div>

                        <?php if ($link_url): ?>
                    </a>
                <?php else: ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
</div>