<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$selected_categories = $settings['selected_categories'];
$posts_per_page = $settings['posts_per_page'];
$show_thumbnail = $settings['show_thumbnail'];
$show_excerpt = $settings['show_excerpt'];
$excerpt_length = $settings['excerpt_length'];
?>

<div class="modernpress-category-tabs modernpress-category-tabs-layout-4">
    <div class="tabs-wrapper">
        <div class="tabs-navigation">
            <?php
            $first_tab = true;
            foreach ($selected_categories as $category_id):
                $category = get_category($category_id);
                if ($category):
                    ?>
                    <div class="tab-title <?php echo $first_tab ? 'active' : ''; ?>"
                        data-tab="category-<?php echo esc_attr($category->term_id); ?>">
                        <span class="tab-text"><?php echo esc_html($category->name); ?></span>
                        <span class="post-count"><?php echo esc_html($category->count); ?></span>
                    </div>
                    <?php
                    $first_tab = false;
                endif;
            endforeach;
            ?>
        </div>
    </div>

    <div class="tabs-content">
        <?php
        $first_tab = true;
        foreach ($selected_categories as $category_id):
            $category = get_category($category_id);
            if ($category):
                $posts = get_posts([
                    'posts_per_page' => $posts_per_page,
                    'category' => $category_id,
                    'orderby' => 'date',
                    'order' => 'DESC',
                ]);
                ?>
                <div class="tab-content <?php echo $first_tab ? 'active' : ''; ?>"
                    id="category-<?php echo esc_attr($category->term_id); ?>">
                    <div class="posts-grid">
                        <?php foreach ($posts as $post):
                            setup_postdata($post);
                            ?>
                            <div class="post-item">
                                <?php if ($show_thumbnail && has_post_thumbnail($post)): ?>
                                    <div class="post-image">
                                        <a href="<?php echo esc_url(get_permalink($post)); ?>">
                                            <?php echo get_the_post_thumbnail($post, 'medium'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="post-content">
                                    <div class="post-meta">
                                        <span class="post-category category-tag">
                                            <?php echo esc_html($category->name); ?>
                                        </span>
                                    </div>

                                    <h3 class="post-title">
                                        <a href="<?php echo esc_url(get_permalink($post)); ?>">
                                            <?php echo esc_html(get_the_title($post)); ?>
                                        </a>
                                    </h3>

                                    <?php if ($show_excerpt): ?>
                                        <div class="post-excerpt">
                                            <?php
                                            $excerpt = get_the_excerpt($post);
                                            echo esc_html(wp_trim_words($excerpt, $excerpt_length, '...')); // Escaped output
                                            ?>
                                        </div>
                                    <?php endif; ?>

                                    <a href="<?php echo esc_url(get_permalink($post)); ?>" class="read-more">
                                        <?php esc_html_e('Read More', 'modernpress-addons'); ?>
                                        <svg width="7" height="12" viewBox="0 0 7 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="currentColor" stroke-width="1.25"
                                                stroke-miterlimit="16" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <?php
                        endforeach;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <?php
                $first_tab = false;
            endif;
        endforeach;
        ?>
    </div>
</div>