<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$image = $settings['image'];
$title = $settings['title'];
$description = $settings['description'];
$button_text = $settings['button_text'];
$link = $settings['link'];

$target = !empty($link['is_external']) ? ' target="_blank"' : '';
$nofollow = !empty($link['nofollow']) ? ' rel="nofollow"' : '';
?>

<div class="modernpress-card modernpress-card-layout-1">
    <div class="modernpress-card-image">
        <?php
        if (!empty($image['id'])) {
            echo wp_get_attachment_image($image['id'], 'full', false, ['class' => 'modernpress-card-image']);
        } else {
            $default_image = wp_get_attachment_url(get_option('modernpress_default_image_id'));
            if (!$default_image) {
                // Create attachment for default image if it doesn't exist
                $response = wp_remote_get($image['url']);
                if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                    $image_contents = wp_remote_retrieve_body($response);
                    $upload = wp_upload_bits(basename($image['url']), null, $image_contents);
                    if (!$upload['error']) {
                        $wp_filetype = wp_check_filetype(basename($upload['file']), null);
                        $attachment = array(
                            'post_mime_type' => $wp_filetype['type'],
                            'post_title' => preg_replace('/\.[^.]+$/', '', basename($upload['file'])),
                            'post_content' => '',
                            'post_status' => 'inherit'
                        );
                        $attach_id = wp_insert_attachment($attachment, $upload['file']);
                        if (!is_wp_error($attach_id)) {
                            require_once(ABSPATH . 'wp-admin/includes/image.php');
                            $attach_data = wp_generate_attachment_metadata($attach_id, $upload['file']);
                            wp_update_attachment_metadata($attach_id, $attach_data);
                            update_option('modernpress_default_image_id', $attach_id);
                            echo wp_get_attachment_image($attach_id, 'full', false, ['class' => 'modernpress-card-image']);
                        }
                    }
                }
            } else {
                $default_id = get_option('modernpress_default_image_id');
                echo wp_get_attachment_image($default_id, 'full', false, ['class' => 'modernpress-card-image']);
            }
        }
        ?>
    </div>
    <div class="modernpress-card-content">
        <?php if ($title): ?>
            <h3 class="modernpress-card-title"><?php echo esc_html($title); ?></h3>
        <?php endif; ?>

        <?php if ($description): ?>
            <div class="modernpress-card-description"><?php echo wp_kses_post($description); ?></div>
        <?php endif; ?>

        <?php if ($button_text && !empty($link['url'])): ?>
            <a href="<?php echo esc_url($link['url']); ?>" class="modernpress-card-button" <?php echo esc_attr($target); ?>
                <?php echo esc_attr($nofollow); ?>>
                <?php echo esc_html($button_text); ?>
                <span class="modernpress-card-button-icon">
                    <svg width="7" height="12" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.750035 1.5L5.25 6.00004L0.75 10.5" stroke="#0D3FB0" stroke-width="1.5"
                            stroke-miterlimit="16" />
                    </svg>
                </span>
            </a>
        <?php endif; ?>
    </div>
</div>