<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$accordion_items = $settings['accordion_items'];
$initial_open = $settings['initial_open'] - 1; // Convert to zero-based index
$multiple_open = $settings['multiple_open'] === 'yes';
?>

<div class="modernpress-accordion modernpress-accordion-layout-2"
    data-multiple="<?php echo $multiple_open ? 'true' : 'false'; ?>">
    <?php foreach ($accordion_items as $index => $item): ?>
        <div class="accordion-item <?php echo $index === $initial_open ? 'active' : ''; ?>"
            data-index="<?php echo esc_attr($index); ?>">
            <div class="accordion-header">
                <?php if (!empty($item['icon']['value'])): ?>
                    <span class="accordion-icon custom-icon">
                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
                    </span>
                <?php endif; ?>

                <h3 class="accordion-title"><?php echo esc_html($item['title']); ?></h3>

                <span class="accordion-toggle-icon">
                    <svg class="toggle-plus" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 5V19M5 12H19" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                    <svg class="toggle-minus" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 12H19" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </span>
            </div>

            <div class="accordion-content">
                <div class="accordion-content-inner">
                    <?php echo wp_kses_post($item['description']); ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>