<?php
namespace ModernPress\Includes;

if (!defined('ABSPATH')) {
    exit;
}

class ModernPress_Loader
{
    private static $instance = null;

    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct()
    {
        $this->load_dependencies();
        $this->init_admin(); // Ensure admin initialization
        $this->enqueue_frontend_assets();
    }

    private function load_dependencies()
    {
        // Load core utilities first
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/class-modernpress-helper.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/class-modernpress-ajax.php';

        // Load plugin components
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/class-modernpress-i18n.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/class-modernpress-elementor-integration.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/class-modernpress-elementor-addons.php';


        // Load admin files
        if (is_admin()) {
            require_once MODERNPRESS_PLUGIN_DIR . 'admin/class-admin.php';
        }
    }
    private function init_admin()
    {
        if (is_admin()) {
            \ModernPress\Admin\Admin::get_instance();
        }
    }

    private function enqueue_frontend_assets()
    {
        add_action('wp_enqueue_scripts', function () {
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-frontend',
                MODERNPRESS_PLUGIN_URL . 'assets/css/style.css',
                [],
                MODERNPRESS_VERSION
            );


            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-frontend',
                MODERNPRESS_PLUGIN_URL . 'assets/js/script.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-team',
                MODERNPRESS_PLUGIN_URL . 'assets/css/team-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-team',
                MODERNPRESS_PLUGIN_URL . 'assets/js/team-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-accordion',
                MODERNPRESS_PLUGIN_URL . 'assets/css/accordion-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-accordion',
                MODERNPRESS_PLUGIN_URL . 'assets/js/accordion-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );

            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-card',
                MODERNPRESS_PLUGIN_URL . 'assets/css/card-widget.css',
                [],
                MODERNPRESS_VERSION
            );

            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-cat-tab',
                MODERNPRESS_PLUGIN_URL . 'assets/css/category-tab-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-cat-tab',
                MODERNPRESS_PLUGIN_URL . 'assets/js/category-tab-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-gallery',
                MODERNPRESS_PLUGIN_URL . 'assets/css/gallery-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-gallery',
                MODERNPRESS_PLUGIN_URL . 'assets/js/gallery-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-posts',
                MODERNPRESS_PLUGIN_URL . 'assets/css/post-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-search',
                MODERNPRESS_PLUGIN_URL . 'assets/css/search-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-social-icons',
                MODERNPRESS_PLUGIN_URL . 'assets/css/social-icons-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-social-icons',
                MODERNPRESS_PLUGIN_URL . 'assets/js/social-icons-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-table',
                MODERNPRESS_PLUGIN_URL . 'assets/css/table-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-table',
                MODERNPRESS_PLUGIN_URL . 'assets/js/table-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-tab',
                MODERNPRESS_PLUGIN_URL . 'assets/css/tab-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'modernpress-tab',
                MODERNPRESS_PLUGIN_URL . 'assets/js/tab-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'modernpress-testimonial-widget',
                MODERNPRESS_PLUGIN_URL . 'assets/css/testimonial-widget.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'client-logos',
                MODERNPRESS_PLUGIN_URL . 'assets/css/client-logos.css',
                [],
                MODERNPRESS_VERSION
            );
            // Enqueue frontend scripts
            wp_enqueue_script(
                'client-logos',
                MODERNPRESS_PLUGIN_URL . 'assets/js/client-logos-widget.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            // Enqueue frontend styles
            wp_enqueue_style(
                'cta',
                MODERNPRESS_PLUGIN_URL . 'assets/css/call-to-action.css',
                [],
                MODERNPRESS_VERSION
            );
            wp_enqueue_style(
                'content-block',
                MODERNPRESS_PLUGIN_URL . 'assets/css/content-block.css',
                [],
                MODERNPRESS_VERSION
            );
            wp_enqueue_script(
                'content-block',
                MODERNPRESS_PLUGIN_URL . 'assets/js/content-block.js',
                ['jquery'], // Dependencies
                MODERNPRESS_VERSION,
                true // Load in footer
            );
            wp_enqueue_style(
                'heading-block',
                MODERNPRESS_PLUGIN_URL . 'assets/css/modernpress-heading.css',
                [],
                MODERNPRESS_VERSION
            );

            wp_enqueue_script(
                'swiper-js',
                get_template_directory_uri() . '/assets/js/swiper-bundle.min.js',
                [],
                '11.0.0',
                true
            );

            // Register Swiper CSS from CDN
            wp_enqueue_style(
                'swiper-css', 
                get_template_directory_uri() . '/assets/css/swiper-bundle.min.css', 
                [], 
                '11.0.0'
            );

            // Register custom slider styles
            wp_register_style(
                'modernpress-slider-styles',
                MODERNPRESS_PLUGIN_URL . 'assets/css/modernpress-slider.css',
                ['swiper'],
                MODERNPRESS_VERSION
            );

            // Register custom slider script that handles both frontend and editor
            wp_register_script(
                'modernpress-slider',
                MODERNPRESS_PLUGIN_URL . 'assets/js/modernpress-slider.js',
                ['jquery', 'swiper', 'elementor-frontend'],
                MODERNPRESS_VERSION,
                true
            );
        });
    }
}