<?php
namespace ModernPress\Includes;

if (!defined('ABSPATH')) {
    exit;
}

class ModernPress_Initializer
{
    public static function init()
    {
        // Check PHP version
        if (version_compare(PHP_VERSION, '7.4', '<')) {
            add_action('admin_notices', [__CLASS__, 'php_version_notice']);
            return;
        }

        // Initialize components
        self::init_components();
        self::register_hooks();
    }

    public static function init_components()
    {
        // Initialize helper first
        ModernPress_Helper::get_instance();

        // Initialize internationalization
        // ModernPress_i18n::init();

        // Initialize Elementor integration
        new ModernPress_Elementor_Integration();
    }

    public static function register_hooks()
    {
        // Register activation, deactivation and uninstall hooks
        register_activation_hook(MODERNPRESS_PLUGIN_DIR . 'modernpress-addons.php', [__CLASS__, 'activate']);
        register_deactivation_hook(MODERNPRESS_PLUGIN_DIR . 'modernpress-addons.php', [__CLASS__, 'deactivate']);
        register_uninstall_hook(MODERNPRESS_PLUGIN_DIR . 'modernpress-addons.php', [__CLASS__, 'uninstall']);

        // Check Elementor dependency
        add_action('admin_init', [__CLASS__, 'check_dependencies']);
    }

    public static function php_version_notice()
    {
        echo '<div class="notice notice-error"><p>' .
            esc_html__('ModernPress Addons requires PHP 7.4 or higher. Please update your PHP version.', 'modernpress-addons') .
            '</p></div>';
    }

    public static function activate()
    {
        self::check_dependencies();
    }

    public static function deactivate()
    {
        // Deactivation tasks
    }

    public static function uninstall()
    {
        // Uninstall tasks will be handled by uninstall.php
    }

    public static function check_dependencies()
    {
        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [__CLASS__, 'elementor_missing_notice']);
            deactivate_plugins(plugin_basename(MODERNPRESS_PLUGIN_DIR . 'modernpress-addons.php'));
        }
    }

    public static function elementor_missing_notice()
    {
        echo '<div class="notice notice-error"><p>' .
            esc_html__('ModernPress Addons requires Elementor to be installed and active. Please install and activate Elementor.', 'modernpress-addons') .
            '</p></div>';
    }
}