<?php
namespace ModernPress\Includes;

if (!defined('ABSPATH')) {
    exit;
}

class ModernPress_Helper
{
    private static $instance = null;

    public static function get_instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    // Rest of your helper methods...
    public function sanitize_text($input)
    {
        return sanitize_text_field($input);
    }

    public function render_svg($svg, $classes = '')
    {
        if (!empty($svg)) {
            echo '<span class="' . esc_attr($classes) . '">' . wp_kses_post($svg) . '</span>';
        }
    }

    public function get_option($option_name, $default = false)
    {
        return get_option($option_name, $default);
    }

    public function update_option($option_name, $value)
    {
        return update_option($option_name, $value);
    }
}