<?php
namespace ModernPress\Includes;

if (!defined('ABSPATH')) {
    exit;
}

class ModernPress_Elementor_Integration
{
    public function __construct()
    {
        add_action('elementor/widgets/register', [$this, 'filter_elementor_widgets'], 20, 1);
    }

    public function filter_elementor_widgets($widgets_manager)
    {
        $activated_widgets = get_option('modernpress_activated_widgets', []);



        if (!in_array('modernpress-icon-box', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('Icon_Box_Widget');
        }
        if (!in_array('modernpress-image-box', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('Image_Box_Widget');
        }
        if (!in_array('modernpress-counter', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('ModernPress_Counter_Widget');
        }
        if (!in_array('modernpress-dual-heading', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('Modernpress_Dual_Heading');
        }
        if (!in_array('modernpress-card-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_card_widget');
        }
        if (!in_array('modernpress-posts-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_posts_widget');
        }
        if (!in_array('modernpress-gallery-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_gallery_widget');
        }
        if (!in_array('modernpress-team-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_team_widget');
        }
        if (!in_array('modernpress-accordian-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_accordion_widget');
        }
        if (!in_array('modernpress-tabs-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_tabs_widget');
        }
        if (!in_array('modernpress-logos-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_client_logos_widget');
        }
        if (!in_array('modernpress-table-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_table_widget');
        }
        if (!in_array('modernpress-social-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_social_icons_widget');
        }
        if (!in_array('modernprss-testimonial-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_testimonial_widget');
        }
        if (!in_array('modernpress-slider-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_slider_widget');
        }
        if (!in_array('modernpress-category-tabs-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_category_tabs_widget');
        }
        if (!in_array('modernpress-search-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_search_widget');
        }
        if (!in_array('modernpress-call-to-action-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_call_to_action_widget');
        }
        if (!in_array('modernpress-content-block-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_content_block_widget');
        }
        if (!in_array('modernpress-heading-widget', $activated_widgets)) {
            $widgets_manager->unregister_widget_type('modernpress_heading_widget');
        }
    }
}