<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Elementor_Addons
{

    public function __construct()
    {
        // Hook into Elementor initialization.
        add_action('elementor/widgets/register', [$this, 'register_widgets']);

        // Add hook for registering categories
        add_action('elementor/elements/categories_registered', [$this, 'add_elementor_widget_categories'], 1);

        // Load assets.
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    /**
     * Add custom widget categories to Elementor
     *
     * @param \Elementor\Elements_Manager $elements_manager Elementor elements manager.
     */
    public function add_elementor_widget_categories($elements_manager)
    {
        $elements_manager->add_category(
            'modernpress',
            [
                'title' => esc_html__('ModernPress', 'modernpress-addons'),
                'icon' => 'fa fa-plug', // You can use any FontAwesome icon
            ]
        );

        // You can add more categories if needed
        $elements_manager->add_category(
            'modernpress-pro',
            [
                'title' => esc_html__('ModernPress Pro', 'modernpress-addons'),
                'icon' => 'fa fa-star',
            ]
        );
    }

    public function register_widgets($widgets_manager)
    {
        // Load widget files


        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-icon-box.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-image-box.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-dual-heading.php'; // Add this line for counter widget
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-card-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-gallery-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-tabs-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-team-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-logos-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-accordian-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-table-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-social-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernprss-testimonial-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-posts-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-slider-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-category-tabs-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-search-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-call-to-action-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-content-block-widget.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'includes/widgets/modernpress-heading-block-widget.php';

        // Register all widgets - they will be filtered later by modernpress_filter_elementor_widgets


        $widgets_manager->register(new \ModernPress\Widgets\Icon_Box_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\Image_Box_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Dual_Heading());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Card_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Gallery_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Tabs_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Team_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Client_Logos_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Accordion_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Table_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Social_Icons_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Testimonial_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Posts_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Slider_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Category_Tabs_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Search_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Call_To_Action_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Content_Block_Widget());
        $widgets_manager->register(new \ModernPress\Widgets\ModernPress_Heading_Block_Widget());
    }


    public function enqueue_scripts()
    {
        wp_enqueue_style('modernpress-style', MODERNPRESS_PLUGIN_URL . 'assets/css/style.css', [], MODERNPRESS_VERSION);
        wp_enqueue_script('modernpress-script', MODERNPRESS_PLUGIN_URL . 'assets/js/script.js', ['jquery'], MODERNPRESS_VERSION, true);
    }
}

// Initialize the class
new ModernPress_Elementor_Addons();