document.addEventListener('DOMContentLoaded', function () {
    // Initialize intersection observer for animation on scroll
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.animationPlayState = 'running';
                observer.unobserve(entry.target);
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '50px'
    });

    // Observe all team members
    const teamMembers = document.querySelectorAll('.modernpress-team-layout-1 .team-member');
    teamMembers.forEach(member => {
        member.style.animationPlayState = 'paused';
        observer.observe(member);
    });

    // Optional: Add hover effect to member images
    teamMembers.forEach(member => {
        const image = member.querySelector('.member-image');
        const overlay = member.querySelector('.member-overlay');

        if (image && overlay) {
            member.removeEventListener('mouseenter', () => {
                overlay.style.opacity = '1';
            });

            member.removeEventListener('mouseleave', () => {
                overlay.style.opacity = '0';
            });
        }
    });

    // Optional: Add social media hover animations
    const socialLinks = document.querySelectorAll('.modernpress-team-layout-1 .social-link');
    socialLinks.forEach(link => {
        link.addEventListener('mouseenter', () => {
            link.style.transform = 'translateY(-3px)';
        });

        link.addEventListener('mouseleave', () => {
            link.style.transform = 'translateY(0)';
        });
    });
});
// layout 6 js 

document.addEventListener('DOMContentLoaded', function () {
    // Initialize intersection observer for animation on scroll
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.animationPlayState = 'running';
                observer.unobserve(entry.target);
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '50px'
    });

    // Observe all team members
    const teamMembers = document.querySelectorAll('.modernpress-team-layout-6 .team-member');
    teamMembers.forEach(member => {
        member.style.animationPlayState = 'paused';
        observer.observe(member);
    });

    // Optional: Add hover effect to member images
    teamMembers.forEach(member => {
        const image = member.querySelector('.member-image');
        const overlay = member.querySelector('.member-overlay');

        if (image && overlay) {
            member.removeEventListener('mouseenter', () => {
                overlay.style.opacity = '1';
            });

            member.removeEventListener('mouseleave', () => {
                overlay.style.opacity = '0';
            });
        }
    });

    // Optional: Add social media hover animations
    const socialLinks = document.querySelectorAll('.modernpress-team-layout-6 .social-link');
    socialLinks.forEach(link => {
        link.addEventListener('mouseenter', () => {
            link.style.transform = 'translateY(-3px)';
        });

        link.addEventListener('mouseleave', () => {
            link.style.transform = 'translateY(0)';
        });
    });
});

// layout 7 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize intersection observer for animation on scroll
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.animationPlayState = 'running';
                    observer.unobserve(entry.target);
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '50px'
        });

        // Observe all team members
        const teamMembers = document.querySelectorAll('.modernpress-team-layout-7 .team-member');
        teamMembers.forEach(member => {
            member.style.animationPlayState = 'paused';
            observer.observe(member);
        });

        // Optional: Add hover effect to member images
        teamMembers.forEach(member => {
            const image = member.querySelector('.member-image');
            const overlay = member.querySelector('.member-overlay');

            if (image && overlay) {
                member.removeEventListener('mouseenter', () => {
                    overlay.style.opacity = '1';
                });

                member.removeEventListener('mouseleave', () => {
                    overlay.style.opacity = '0';
                });
            }
        });

        // Optional: Add social media hover animations
        const socialLinks = document.querySelectorAll('.modernpress-team-layout-7 .social-link');
        socialLinks.forEach(link => {
            link.addEventListener('mouseenter', () => {
                link.style.transform = 'translateY(-3px)';
            });

            link.addEventListener('mouseleave', () => {
                link.style.transform = 'translateY(0)';
            });
        });
    });

    // layout 8 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize intersection observer for animation on scroll
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.animationPlayState = 'running';
                    observer.unobserve(entry.target);
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '50px'
        });

        // Observe all team members
        const teamMembers = document.querySelectorAll('.modernpress-team-layout-8 .team-member');
        teamMembers.forEach(member => {
            member.style.animationPlayState = 'paused';
            observer.observe(member);
        });

        // Optional: Add hover effect to member images
        teamMembers.forEach(member => {
            const image = member.querySelector('.member-image');
            const overlay = member.querySelector('.member-overlay');

            if (image && overlay) {
                member.removeEventListener('mouseenter', () => {
                    overlay.style.opacity = '1';
                });

                member.removeEventListener('mouseleave', () => {
                    overlay.style.opacity = '0';
                });
            }
        });

        // Optional: Add social media hover animations
        const socialLinks = document.querySelectorAll('.modernpress-team-layout-8 .social-link');
        socialLinks.forEach(link => {
            link.addEventListener('mouseenter', () => {
                link.style.transform = 'translateY(-3px)';
            });

            link.addEventListener('mouseleave', () => {
                link.style.transform = 'translateY(0)';
            });
        });
    });