
document.addEventListener('DOMContentLoaded', function () {
        const tableContainer = document.querySelector('.modernpress-table-layout-1');
        if (!tableContainer) return;

        const table = tableContainer.querySelector('.modernpress-table');
        const tbody = table.querySelector('tbody');
        const tableInfo = tableContainer.querySelector('.table-info');
        const paginationContainer = tableContainer.querySelector('.pagination-numbers');
        const prevButton = tableContainer.querySelector('.pagination-arrow.prev');
        const nextButton = tableContainer.querySelector('.pagination-arrow.next');
        const searchInput = tableContainer.querySelector('.table-search input');

        let currentPage = 1;
        let rowsPerPage = <?php echo esc_js($rows_per_page); ?>;
        let allRows = [];
        let filteredRows = [];

        function initializeTable() {
            allRows = Array.from(tbody.querySelectorAll('tr'));
            filteredRows = [...allRows];
            updateTable();
        }

        function filterRows(searchTerm) {
            if (!searchTerm) {
                filteredRows = [...allRows];
            } else {
                filteredRows = allRows.filter(row => {
                    return Array.from(row.querySelectorAll('td'))
                        .some(cell => cell.textContent.toLowerCase().includes(searchTerm.toLowerCase()));
                });
            }
            currentPage = 1;
            updateTable();
        }

        function updateTable() {
            const startIndex = (currentPage - 1) * rowsPerPage;
            const endIndex = startIndex + rowsPerPage;
            const displayedRows = filteredRows.slice(startIndex, endIndex);

            // Hide all rows first
            allRows.forEach(row => {
                row.style.display = 'none';
            });

            // Show only filtered rows for current page
            displayedRows.forEach(row => {
                row.style.display = '';
            });

            updateInfoText();
            updatePagination();
        }

        function updateInfoText() {
            if (!tableInfo) return;

            const totalRows = filteredRows.length;
            const startIndex = totalRows === 0 ? 0 : (currentPage - 1) * rowsPerPage + 1;
            const endIndex = Math.min(startIndex + rowsPerPage - 1, totalRows);
            tableInfo.textContent = `Showing ${startIndex} to ${endIndex} of ${totalRows} entries`;
        }

        function updatePagination() {
            if (!paginationContainer) return;

            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
            let paginationHTML = '';

            if (totalPages <= 5) {
                // Show all pages if 5 or less
                for (let i = 1; i <= totalPages; i++) {
                    paginationHTML += `<button class="page-number${currentPage === i ? ' active' : ''}" data-page="${i}">${i}</button>`;
                }
            } else {
                // Show first page
                paginationHTML += `<button class="page-number${currentPage === 1 ? ' active' : ''}" data-page="1">1</button>`;

                // Add dots or middle pages
                if (currentPage > 3) {
                    paginationHTML += `<button class="page-number dots">...</button>`;
                }

                // Middle pages
                const middleStart = Math.max(2, currentPage - 1);
                const middleEnd = Math.min(totalPages - 1, currentPage + 1);

                for (let i = middleStart; i <= middleEnd; i++) {
                    if (i > 1 && i < totalPages) {
                        paginationHTML += `<button class="page-number${currentPage === i ? ' active' : ''}" data-page="${i}">${i}</button>`;
                    }
                }

                // Add dots before last page
                if (currentPage < totalPages - 2) {
                    paginationHTML += `<button class="page-number dots">...</button>`;
                }

                // Show last page
                paginationHTML += `<button class="page-number${currentPage === totalPages ? ' active' : ''}" data-page="${totalPages}">${totalPages}</button>`;
            }

            paginationContainer.innerHTML = paginationHTML;

            // Update arrow buttons state
            if (prevButton) {
                prevButton.disabled = currentPage === 1;
            }
            if (nextButton) {
                nextButton.disabled = currentPage === totalPages;
            }

            // Add click events to page numbers
            paginationContainer.querySelectorAll('.page-number:not(.dots)').forEach(button => {
                button.addEventListener('click', () => {
                    currentPage = parseInt(button.dataset.page);
                    updateTable();
                });
            });
        }

        // Event Listeners
        if (prevButton) {
            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    updateTable();
                }
            });
        }

        if (nextButton) {
            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    updateTable();
                }
            });
        }

        if (searchInput) {
            let searchTimeout;
            searchInput.addEventListener('input', (e) => {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    filterRows(e.target.value);
                }, 300);
            });
        }

        // Initialize table
        initializeTable();
    });

    // table widget layout 2 js 

    
    document.addEventListener('DOMContentLoaded', function () {
        const tableContainer = document.querySelector('.modernpress-table-layout-2');
        if (!tableContainer) return;

        const table = tableContainer.querySelector('.modernpress-table');
        const tableInfo = tableContainer.querySelector('.table-info');
        const paginationContainer = tableContainer.querySelector('.pagination-numbers');
        const prevButton = tableContainer.querySelector('.pagination-arrow.prev');
        const nextButton = tableContainer.querySelector('.pagination-arrow.next');
        const searchInput = tableContainer.querySelector('.table-search input');
        const entriesSelect = tableContainer.querySelector('.entries-select');

        let currentPage = 1;
        let rowsPerPage = parseInt(entriesSelect?.value || <?php echo esc_js($rows_per_page); ?>);
        let allRows = [];
        let filteredRows = [];

        function initializeTable() {
            // Skip header row when collecting all rows
            allRows = Array.from(table.querySelectorAll('tr')).slice(1);
            filteredRows = [...allRows];
            updateTable();
        }

        function filterRows(searchTerm) {
            if (!searchTerm) {
                filteredRows = [...allRows];
            } else {
                filteredRows = allRows.filter(row => {
                    const text = Array.from(row.cells)
                        .map(cell => cell.textContent.toLowerCase())
                        .join(' ');
                    return text.includes(searchTerm.toLowerCase());
                });
            }
            currentPage = 1;
            updateTable();
        }

        function updateTable() {
            const startIndex = (currentPage - 1) * rowsPerPage;
            const endIndex = startIndex + rowsPerPage;

            // Hide all rows first
            allRows.forEach(row => row.style.display = 'none');

            // Show only filtered rows for current page
            filteredRows.slice(startIndex, endIndex).forEach(row => row.style.display = '');

            updateInfoText();
            updatePagination();
        }

        function updateInfoText() {
            if (!tableInfo) return;

            const totalRows = filteredRows.length;
            const startIndex = totalRows === 0 ? 0 : (currentPage - 1) * rowsPerPage + 1;
            const endIndex = Math.min(startIndex + rowsPerPage - 1, totalRows);
            tableInfo.textContent = `Showing ${startIndex} to ${endIndex} of ${totalRows} entries`;
        }

        function updatePagination() {
            if (!paginationContainer) return;

            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
            let paginationHTML = '';

            if (totalPages <= 5) {
                for (let i = 1; i <= totalPages; i++) {
                    paginationHTML += `<button class="page-number${currentPage === i ? ' active' : ''}" data-page="${i}">${i}</button>`;
                }
            } else {
                // First page
                paginationHTML += `<button class="page-number${currentPage === 1 ? ' active' : ''}" data-page="1">1</button>`;

                // Middle section
                if (currentPage > 3) {
                    paginationHTML += `<button class="page-number dots">...</button>`;
                }

                for (let i = Math.max(2, currentPage - 1); i <= Math.min(totalPages - 1, currentPage + 1); i++) {
                    paginationHTML += `<button class="page-number${currentPage === i ? ' active' : ''}" data-page="${i}">${i}</button>`;
                }

                if (currentPage < totalPages - 2) {
                    paginationHTML += `<button class="page-number dots">...</button>`;
                }

                // Last page
                paginationHTML += `<button class="page-number${currentPage === totalPages ? ' active' : ''}" data-page="${totalPages}">${totalPages}</button>`;
            }

            paginationContainer.innerHTML = paginationHTML;

            // Update arrow buttons
            if (prevButton) {
                prevButton.disabled = currentPage === 1;
            }
            if (nextButton) {
                nextButton.disabled = currentPage === totalPages;
            }

            // Add click events to page numbers
            paginationContainer.querySelectorAll('.page-number:not(.dots)').forEach(button => {
                button.addEventListener('click', () => {
                    currentPage = parseInt(button.dataset.page);
                    updateTable();
                });
            });
        }

        // Event Listeners
        if (prevButton) {
            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    updateTable();
                }
            });
        }

        if (nextButton) {
            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    updateTable();
                }
            });
        }

        if (searchInput) {
            let searchTimeout;
            searchInput.addEventListener('input', (e) => {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    filterRows(e.target.value);
                }, 300);
            });
        }

        if (entriesSelect) {
            entriesSelect.addEventListener('change', (e) => {
                rowsPerPage = parseInt(e.target.value);
                currentPage = 1;
                updateTable();
            });
        }

        // Initialize table
        initializeTable();
    });