 document.addEventListener('DOMContentLoaded', function () {
        const container = document.querySelector('.modernpress-tabs-layout-1');
        if (!container) return;

        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');
        const indicator = container.querySelector('.tab-indicator');

        function updateIndicator(activeTab) {
            const tabRect = activeTab.getBoundingClientRect();
            const navigationRect = container.querySelector('.tabs-navigation').getBoundingClientRect();

            indicator.style.width = `${tabRect.width}px`;
            indicator.style.left = `${tabRect.left - navigationRect.left}px`;
        }

        function switchTab(e) {
            const clickedTab = e.currentTarget;
            const tabId = clickedTab.dataset.tab;

            // Remove active classes
            tabs.forEach(tab => tab.classList.remove('active'));
            contents.forEach(content => content.classList.remove('active'));

            // Add active classes
            clickedTab.classList.add('active');
            container.querySelector(`#${tabId}`).classList.add('active');

            // Update indicator
            updateIndicator(clickedTab);
        }

        // Add click handlers
        tabs.forEach(tab => {
            tab.addEventListener('click', switchTab);
        });

        // Initialize indicator position
        const activeTab = container.querySelector('.tab-title.active');
        if (activeTab) {
            updateIndicator(activeTab);
        }

        // Handle window resize
        let resizeTimeout;
        window.addEventListener('resize', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(() => {
                const activeTab = container.querySelector('.tab-title.active');
                if (activeTab) {
                    updateIndicator(activeTab);
                }
            }, 250);
        });

        // Add keyboard navigation
        tabs.forEach((tab, index) => {
            tab.setAttribute('tabindex', '0');
            tab.setAttribute('role', 'tab');

            tab.addEventListener('keydown', (e) => {
                let targetTab;

                switch (e.key) {
                    case 'ArrowLeft':
                        targetTab = index > 0 ? tabs[index - 1] : tabs[tabs.length - 1];
                        break;
                    case 'ArrowRight':
                        targetTab = index < tabs.length - 1 ? tabs[index + 1] : tabs[0];
                        break;
                }

                if (targetTab) {
                    e.preventDefault();
                    targetTab.click();
                    targetTab.focus();
                }
            });
        });
    });

    // tab widget layout 2 js 

    document.addEventListener('DOMContentLoaded', function () {
        const container = document.querySelector('.modernpress-tabs-layout-2');
        if (!container) return;

        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');

        function switchTab(e) {
            const clickedTab = e.currentTarget;
            const tabId = clickedTab.dataset.tab;

            // Remove active classes
            tabs.forEach(tab => tab.classList.remove('active'));
            contents.forEach(content => content.classList.remove('active'));

            // Add active classes
            clickedTab.classList.add('active');
            container.querySelector(`#${tabId}`).classList.add('active');

            // Ensure active tab is visible in scroll view
            clickedTab.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'nearest' });
        }

        // Add click handlers
        tabs.forEach(tab => {
            tab.addEventListener('click', switchTab);
        });

        // Add keyboard navigation
        tabs.forEach((tab, index) => {
            tab.setAttribute('tabindex', '0');
            tab.setAttribute('role', 'tab');

            tab.addEventListener('keydown', (e) => {
                let targetTab;

                switch (e.key) {
                    case 'ArrowLeft':
                        targetTab = index > 0 ? tabs[index - 1] : tabs[tabs.length - 1];
                        break;
                    case 'ArrowRight':
                        targetTab = index < tabs.length - 1 ? tabs[index + 1] : tabs[0];
                        break;
                    case 'Home':
                        targetTab = tabs[0];
                        break;
                    case 'End':
                        targetTab = tabs[tabs.length - 1];
                        break;
                    default:
                        return;
                }

                e.preventDefault();
                targetTab.click();
                targetTab.focus();
            });
        });
    });

    // tab widget layout 3 js 

    document.addEventListener('DOMContentLoaded', function () {
        const container = document.querySelector('.modernpress-tabs-layout-3');
        if (!container) return;

        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');

        function switchTab(e) {
            const clickedTab = e.currentTarget;
            const tabId = clickedTab.dataset.tab;

            // Remove active classes
            tabs.forEach(tab => tab.classList.remove('active'));
            contents.forEach(content => content.classList.remove('active'));

            // Add active classes
            clickedTab.classList.add('active');
            container.querySelector(`#${tabId}`).classList.add('active');

            // Ensure active tab is visible in scroll view
            clickedTab.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'nearest' });
        }

        // Add click handlers
        tabs.forEach(tab => {
            tab.addEventListener('click', switchTab);
        });

        // Add keyboard navigation
        tabs.forEach((tab, index) => {
            tab.setAttribute('tabindex', '0');
            tab.setAttribute('role', 'tab');

            tab.addEventListener('keydown', (e) => {
                let targetTab;

                switch (e.key) {
                    case 'ArrowLeft':
                        targetTab = index > 0 ? tabs[index - 1] : tabs[tabs.length - 1];
                        break;
                    case 'ArrowRight':
                        targetTab = index < tabs.length - 1 ? tabs[index + 1] : tabs[0];
                        break;
                    case 'Home':
                        targetTab = tabs[0];
                        break;
                    case 'End':
                        targetTab = tabs[tabs.length - 1];
                        break;
                    default:
                        return;
                }

                e.preventDefault();
                targetTab.click();
                targetTab.focus();
            });
        });
    });

    // tab widget layout 4 js 

    document.addEventListener('DOMContentLoaded', function () {
        const container = document.querySelector('.modernpress-tabs-layout-4');
        if (!container) return;

        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');

        function switchTab(e) {
            const clickedTab = e.currentTarget;
            const tabId = clickedTab.dataset.tab;

            // Remove active classes
            tabs.forEach(tab => tab.classList.remove('active'));
            contents.forEach(content => content.classList.remove('active'));

            // Add active classes
            clickedTab.classList.add('active');
            container.querySelector(`#${tabId}`).classList.add('active');
        }

        // Add click handlers
        tabs.forEach(tab => {
            tab.addEventListener('click', switchTab);
        });

        // Add keyboard navigation
        tabs.forEach((tab, index) => {
            tab.setAttribute('tabindex', '0');
            tab.setAttribute('role', 'tab');

            tab.addEventListener('keydown', (e) => {
                let targetTab;

                switch (e.key) {
                    case 'ArrowLeft':
                        targetTab = index > 0 ? tabs[index - 1] : tabs[tabs.length - 1];
                        break;
                    case 'ArrowRight':
                        targetTab = index < tabs.length - 1 ? tabs[index + 1] : tabs[0];
                        break;
                    case 'Home':
                        targetTab = tabs[0];
                        break;
                    case 'End':
                        targetTab = tabs[tabs.length - 1];
                        break;
                    case 'Enter':
                    case ' ':
                        e.preventDefault();
                        tab.click();
                        return;
                    default:
                        return;
                }

                if (targetTab) {
                    e.preventDefault();
                    targetTab.click();
                    targetTab.focus();
                }
            });
        });
    });

    // tab widget layout 5 js 

    document.addEventListener('DOMContentLoaded', function () {
        const container = document.querySelector('.modernpress-tabs-layout-5');
        if (!container) return;

        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');

        function switchTab(e) {
            const clickedTab = e.currentTarget;
            const tabId = clickedTab.dataset.tab;

            // Remove active classes
            tabs.forEach(tab => tab.classList.remove('active'));
            contents.forEach(content => content.classList.remove('active'));

            // Add active classes
            clickedTab.classList.add('active');
            container.querySelector(`#${tabId}`).classList.add('active');
        }

        // Add click handlers
        tabs.forEach(tab => {
            tab.addEventListener('click', switchTab);
        });

        // Add keyboard navigation
        tabs.forEach((tab, index) => {
            tab.setAttribute('tabindex', '0');
            tab.setAttribute('role', 'tab');

            tab.addEventListener('keydown', (e) => {
                let targetTab;

                switch (e.key) {
                    case 'ArrowUp':
                        targetTab = index > 0 ? tabs[index - 1] : tabs[tabs.length - 1];
                        break;
                    case 'ArrowDown':
                        targetTab = index < tabs.length - 1 ? tabs[index + 1] : tabs[0];
                        break;
                    case 'Home':
                        targetTab = tabs[0];
                        break;
                    case 'End':
                        targetTab = tabs[tabs.length - 1];
                        break;
                    case 'Enter':
                    case ' ':
                        e.preventDefault();
                        tab.click();
                        return;
                    default:
                        return;
                }

                if (targetTab) {
                    e.preventDefault();
                    targetTab.click();
                    targetTab.focus();
                }
            });
        });
    });