
    document.addEventListener('DOMContentLoaded', function () {
        // Convert hex colors to RGB for shadow effects
        const socialIcons = document.querySelectorAll('.modernpress-social-icons-layout-3 .social-icon-link');

        socialIcons.forEach(icon => {
            const hexColor = getComputedStyle(icon).getPropertyValue('--brand-color').trim();
            const rgb = hexToRgb(hexColor);
            if (rgb) {
                icon.style.setProperty('--brand-color-rgb', `${rgb.r}, ${rgb.g}, ${rgb.b}`);
            }
        });

        function hexToRgb(hex) {
            const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
            return result ? {
                r: parseInt(result[1], 16),
                g: parseInt(result[2], 16),
                b: parseInt(result[3], 16)
            } : null;
        }
    });