(function ($) {
    "use strict";

    // Initialize ModernPress Slider
    function initModernPressSlider() {
        // Find all slider instances on the page
        document.querySelectorAll('.modernpress-slider-wrapper').forEach(function (sliderWrapper) {
            // Get the slider settings from the data attribute
            var settings = JSON.parse(sliderWrapper.getAttribute('data-settings'));
            var sliderId = sliderWrapper.getAttribute('data-slider-id');
            var layout = settings.layout || 'layout-1';
            
            // Configuration based on layout
            var swiperConfig = {
                // Basic settings
                slidesPerView: parseInt(settings.slides_to_show) || 1,
                spaceBetween: parseInt(settings.slides_spacing) || 30,
                loop: settings.loop === 'yes',
                speed: parseInt(settings.speed) || 500,
                
                // Autoplay settings
                autoplay: settings.autoplay === 'yes' ? {
                    delay: parseInt(settings.autoplay_speed) || 5000,
                    disableOnInteraction: false
                } : false,
                
                // Pagination settings
                pagination: settings.pagination === 'yes' ? {
                    el: '.swiper-pagination',
                    clickable: true,
                    type: settings.pagination_type || 'bullets'
                } : false
            };
            
            // Layout specific settings
            if (layout === 'layout-1') {
                // Horizontal slider (layout-1)
                swiperConfig.effect = settings.effect || 'slide';
                swiperConfig.centeredSlides = settings.center_slides === 'yes';
                
                // Navigation for layout-1
                if (settings.navigation === 'yes') {
                    swiperConfig.navigation = {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    };
                }
                
                // Responsive breakpoints for layout-1
                swiperConfig.breakpoints = {
                    0: {
                        slidesPerView: parseInt(settings.slides_to_show_mobile) || 1,
                    },
                    768: {
                        slidesPerView: parseInt(settings.slides_to_show_tablet) || 1,
                    },
                    1024: {
                        slidesPerView: parseInt(settings.slides_to_show) || 1,
                    }
                };
                
                // Initialize horizontal Swiper
                var swiper = new Swiper(sliderWrapper.querySelector('.swiper'), swiperConfig);
                
            } else if (layout === 'layout-2') {
                // Vertical slider (layout-2)
                var verticalSwiperConfig = {
                    direction: "vertical",
                    slidesPerView: 1,
                    spaceBetween: 30,
                    mousewheel: true,
                    loop: settings.loop === 'yes',
                    speed: parseInt(settings.speed) || 500,
                    autoplay: settings.autoplay === 'yes' ? {
                        delay: parseInt(settings.autoplay_speed) || 5000,
                        disableOnInteraction: false
                    } : false,
                    pagination: settings.pagination === 'yes' ? {
                        el: '.swiper-pagination',
                        clickable: true,
                    } : false
                };
                
                // Initialize vertical Swiper
                var verticalSwiper = new Swiper(sliderWrapper.querySelector('.mySwiper-vertical'), verticalSwiperConfig);
            }
            
            // Add the slider instance to window object for external access if needed
            if (!window.ModernPressSliders) {
                window.ModernPressSliders = {};
            }
            window.ModernPressSliders[sliderId] = layout === 'layout-1' ? swiper : verticalSwiper;
        });
    }

    // Initialize on document.ready
    $(document).ready(function () {
        initModernPressSlider();
    });

    // Initialize when Elementor frontend is initialized (for Elementor editor)
    $(window).on('elementor/frontend/init', function () {
        if (typeof elementorFrontend !== 'undefined') {
            elementorFrontend.hooks.addAction('frontend/element_ready/modernpress_slider_widget.default', function ($scope) {
                initModernPressSlider();
            });
        }
    });

})(jQuery);