(function($) {
    'use strict';

    var ModernPressGallery = {
        init: function() {
            this.initMasonry();
            this.initJustified();
            this.handleResponsive();
        },

        initMasonry: function() {
            $('.modernpress-gallery-masonry').each(function() {
                var $gallery = $(this);
                $gallery.imagesLoaded(function() {
                    $gallery.masonry({
                        itemSelector: '.gallery-item',
                        percentPosition: true
                    });
                });
            });
        },

        initJustified: function() {
            $('.modernpress-gallery-justified').each(function() {
                var $gallery = $(this);
                $gallery.imagesLoaded(function() {
                    // Ensure all images are loaded before calculating layout
                    ModernPressGallery.calculateJustifiedLayout($gallery);
                });
            });
        },

        calculateJustifiedLayout: function($gallery) {
            var containerWidth = $gallery.width();
            var targetHeight = 200; // Base height
            var $items = $gallery.find('.gallery-item');
            var currentRow = [];
            var currentRowWidth = 0;

            $items.each(function() {
                var $item = $(this);
                var img = $item.find('img')[0];
                var aspectRatio = img.naturalWidth / img.naturalHeight;
                var targetWidth = targetHeight * aspectRatio;

                if (currentRowWidth + targetWidth > containerWidth) {
                    // Adjust current row
                    ModernPressGallery.adjustRowItems(currentRow, containerWidth);
                    currentRow = [];
                    currentRowWidth = 0;
                }

                currentRow.push({
                    $item: $item,
                    width: targetWidth,
                    height: targetHeight
                });
                currentRowWidth += targetWidth;
            });

            // Handle last row
            if (currentRow.length > 0) {
                ModernPressGallery.adjustRowItems(currentRow, containerWidth);
            }
        },

        adjustRowItems: function(items, containerWidth) {
            var totalWidth = items.reduce(function(sum, item) {
                return sum + item.width;
            }, 0);

            var ratio = containerWidth / totalWidth;

            items.forEach(function(item) {
                item.$item.css({
                    width: Math.floor(item.width * ratio) + 'px',
                    height: Math.floor(item.height * ratio) + 'px'
                });
            });
        },

        handleResponsive: function() {
            var resizeTimer;
            $(window).on('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    $('.modernpress-gallery-masonry').masonry('layout');
                    $('.modernpress-gallery-justified').each(function() {
                        ModernPressGallery.calculateJustifiedLayout($(this));
                    });
                }, 250);
            });
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        ModernPressGallery.init();
    });

    // Re-initialize when Elementor editor is loaded
    if (window.elementorFrontend) {
        elementorFrontend.hooks.addAction('frontend/element_ready/modernpress_gallery_widget.default', function($scope) {
            ModernPressGallery.init();
        });
    }

})(jQuery);