jQuery(document).ready(function ($) {
        // Initialize Elementor lightbox
        const galleryItems = $('.modernpress-gallery-layout-1 .gallery-lightbox');

        if (galleryItems.length) {
            galleryItems.on('click', function (e) {
                if ($(this).data('elementor-open-lightbox') === 'yes') {
                    e.preventDefault();

                    const elements = [];
                    galleryItems.each(function () {
                        elements.push({
                            type: 'image',
                            url: $(this).attr('href'),
                            title: $(this).data('elementor-lightbox-title')
                        });
                    });

                    const lightbox = elementorFrontend.utils.lightbox;
                    lightbox.showModal({
                        type: 'slideshow',
                        modalOptions: {
                            id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-1').data('id'),
                            entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                        },
                        slideshow: {
                            slides: elements,
                            swiper: {
                                initialSlide: $(this).index()
                            }
                        }
                    });
                }
            });
        }
    });

    // gallery widget laayout 2 js 

    jQuery(document).ready(function ($) {
        // Initialize masonry layout with ImagesLoaded
        var grid = document.querySelector('.masonry-grid');
        imagesLoaded(grid, function () {
            grid.classList.add('images-loaded');
        });

        // Initialize Elementor lightbox
        const galleryItems = $('.modernpress-gallery-layout-2 .gallery-lightbox');

        if (galleryItems.length) {
            galleryItems.on('click', function (e) {
                if ($(this).data('elementor-open-lightbox') === 'yes') {
                    e.preventDefault();

                    const elements = [];
                    galleryItems.each(function () {
                        elements.push({
                            type: 'image',
                            url: $(this).attr('href'),
                            title: $(this).data('elementor-lightbox-title')
                        });
                    });

                    const lightbox = elementorFrontend.utils.lightbox;
                    lightbox.showModal({
                        type: 'slideshow',
                        modalOptions: {
                            id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-2').data('id'),
                            entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                        },
                        slideshow: {
                            slides: elements,
                            swiper: {
                                initialSlide: $(this).index(),
                                effect: '<?php echo esc_js($lightbox_animation); ?>',
                                autoplay: false,
                                loop: true,
                                keyboard: true
                            }
                        }
                    });
                }
            });
        }
    });
    // gallery widget laayout 3 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize intersection observer for animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '50px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.animationPlayState = 'running';
                    observer.unobserve(entry.target);
                }
            });
        }, observerOptions);

        // Observe all gallery items
        const items = document.querySelectorAll('.modernpress-gallery-layout-3 .gallery-item');
        items.forEach(item => {
            item.style.animationPlayState = 'paused';
            observer.observe(item);
        });

        // Optional: Add image loading optimization
        const images = document.querySelectorAll('.modernpress-gallery-layout-3 .gallery-item-image img');
        images.forEach(img => {
            if ('loading' in HTMLImageElement.prototype) {
                img.loading = 'lazy';
            }
        });
        // Initialize Elementor lightbox
        jQuery(function ($) {
            const galleryItems = $('.modernpress-gallery-layout-3 .gallery-lightbox');

            if (galleryItems.length) {
                galleryItems.on('click', function (e) {
                    if ($(this).data('elementor-open-lightbox') === 'yes') {
                        e.preventDefault();

                        const elements = [];
                        galleryItems.each(function () {
                            elements.push({
                                type: 'image',
                                url: $(this).attr('href'),
                                title: $(this).data('elementor-lightbox-title')
                            });
                        });

                        const lightbox = elementorFrontend.utils.lightbox;
                        lightbox.showModal({
                            type: 'slideshow',
                            modalOptions: {
                                id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-3').data('id'),
                                entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                            },
                            slideshow: {
                                slides: elements,
                                swiper: {
                                    initialSlide: $(this).closest('.gallery-item').index(),
                                    effect: '<?php echo esc_js($lightbox_animation); ?>',
                                    autoplay: false,
                                    loop: true,
                                    keyboard: true,
                                    speed: 500,
                                    navigation: {
                                        prevEl: '.elementor-swiper-button-prev',
                                        nextEl: '.elementor-swiper-button-next',
                                    },
                                }
                            }
                        });
                    }
                });

                // Add keyboard navigation
                $(document).on('keydown', function (e) {
                    if ($('.elementor-lightbox').length) {
                        switch (e.key) {
                            case 'Escape':
                                $('.elementor-lightbox .dialog-lightbox-close-button').click();
                                break;
                            case 'ArrowLeft':
                                $('.elementor-lightbox .elementor-swiper-button-prev').click();
                                break;
                            case 'ArrowRight':
                                $('.elementor-lightbox .elementor-swiper-button-next').click();
                                break;
                        }
                    }
                });
            }
        });
    });

    // gallery widget laayout 4 js 

    document.addEventListener('DOMContentLoaded', function () {
        const carousel = document.querySelector('.modernpress-gallery-layout-4');
        const track = carousel.querySelector('.carousel-track');
        const items = carousel.querySelectorAll('.gallery-item');
        const prevBtn = carousel.querySelector('.carousel-prev');
        const nextBtn = carousel.querySelector('.carousel-next');
        const dotsContainer = carousel.querySelector('.carousel-dots');

        let currentIndex = 0;
        const itemWidth = items[0].offsetWidth;
        const itemsPerView = window.innerWidth > 1200 ? 3 : window.innerWidth > 768 ? 2 : 1;
        const totalSlides = Math.ceil(items.length / itemsPerView);

        // Create dots
        for (let i = 0; i < totalSlides; i++) {
            const dot = document.createElement('button');
            dot.classList.add('carousel-dot');
            if (i === 0) dot.classList.add('active');
            dot.setAttribute('aria-label', `Go to slide ${i + 1}`);
            dotsContainer.appendChild(dot);

            dot.addEventListener('click', () => {
                goToSlide(i);
            });
        }

        function goToSlide(index) {
            currentIndex = index;
            const offset = -(currentIndex * itemWidth * itemsPerView);
            track.style.transform = `translateX(${offset}px)`;
            updateDots();
        }

        function updateDots() {
            const dots = carousel.querySelectorAll('.carousel-dot');
            dots.forEach((dot, index) => {
                dot.classList.toggle('active', index === currentIndex);
            });
        }

        prevBtn?.addEventListener('click', () => {
            if (currentIndex > 0) {
                goToSlide(currentIndex - 1);
            }
        });

        nextBtn?.addEventListener('click', () => {
            if (currentIndex < totalSlides - 1) {
                goToSlide(currentIndex + 1);
            }
        });

        // Touch events for mobile
        let touchStartX = 0;
        let touchEndX = 0;

        track.addEventListener('touchstart', e => {
            touchStartX = e.touches[0].clientX;
        });

        track.addEventListener('touchend', e => {
            touchEndX = e.changedTouches[0].clientX;
            handleSwipe();
        });

        function handleSwipe() {
            const swipeDistance = touchEndX - touchStartX;
            if (Math.abs(swipeDistance) > 50) {
                if (swipeDistance > 0 && currentIndex > 0) {
                    goToSlide(currentIndex - 1);
                } else if (swipeDistance < 0 && currentIndex < totalSlides - 1) {
                    goToSlide(currentIndex + 1);
                }
            }
        }
    });
    jQuery(document).ready(function ($) {
        // Initialize Elementor lightbox
        const galleryItems = $('.modernpress-gallery-layout-1 .gallery-lightbox');

        if (galleryItems.length) {
            galleryItems.on('click', function (e) {
                if ($(this).data('elementor-open-lightbox') === 'yes') {
                    e.preventDefault();

                    const elements = [];
                    galleryItems.each(function () {
                        elements.push({
                            type: 'image',
                            url: $(this).attr('href'),
                            title: $(this).data('elementor-lightbox-title')
                        });
                    });

                    const lightbox = elementorFrontend.utils.lightbox;
                    lightbox.showModal({
                        type: 'slideshow',
                        modalOptions: {
                            id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-1').data('id'),
                            entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                        },
                        slideshow: {
                            slides: elements,
                            swiper: {
                                initialSlide: $(this).index()
                            }
                        }
                    });
                }
            });
        }
    });

    // gallery widget laayout 5 js 

    document.addEventListener('DOMContentLoaded', function () {
        const gallery = document.querySelector('.modernpress-gallery-layout-5');
        const filterButtons = gallery.querySelectorAll('.filter-button');
        const items = gallery.querySelectorAll('.gallery-item');

        // Initialize filtering
        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                const filter = button.dataset.filter;

                // Update active button
                filterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');

                // Filter items
                items.forEach(item => {
                    const category = item.dataset.category;
                    if (filter === 'all' || filter === category) {
                        item.classList.remove('hidden');
                    } else {
                        item.classList.add('hidden');
                    }
                });
            });
        });

        jQuery(document).ready(function ($) {
            // Initialize Elementor lightbox
            const galleryItems = $('.modernpress-gallery-layout-1 .gallery-lightbox');

            if (galleryItems.length) {
                galleryItems.on('click', function (e) {
                    if ($(this).data('elementor-open-lightbox') === 'yes') {
                        e.preventDefault();

                        const elements = [];
                        galleryItems.each(function () {
                            elements.push({
                                type: 'image',
                                url: $(this).attr('href'),
                                title: $(this).data('elementor-lightbox-title')
                            });
                        });

                        const lightbox = elementorFrontend.utils.lightbox;
                        lightbox.showModal({
                            type: 'slideshow',
                            modalOptions: {
                                id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-1').data('id'),
                                entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                            },
                            slideshow: {
                                slides: elements,
                                swiper: {
                                    initialSlide: $(this).index()
                                }
                            }
                        });
                    }
                });
            }
        });
    });

    // gallery widget laayout 6 js 

    document.addEventListener('DOMContentLoaded', function () {
        const gallery = document.querySelector('.modernpress-gallery-layout-6');
        const items = gallery.querySelectorAll('.gallery-item');

        // Mouse move effect
        items.forEach(item => {
            item.addEventListener('mousemove', (e) => {
                const rect = item.getBoundingClientRect();
                const centerX = rect.left + rect.width / 2;
                const centerY = rect.top + rect.height / 2;

                const rotateX = (centerY - e.clientY) / 20;
                const rotateY = (e.clientX - centerX) / 20;

                item.classList.add('mouse-move');
                item.style.setProperty('--rotateX', `${rotateX}deg`);
                item.style.setProperty('--rotateY', `${rotateY}deg`);
            });

            item.addEventListener('mouseleave', () => {
                item.classList.remove('mouse-move');
                item.style.setProperty('--rotateX', '0deg');
                item.style.setProperty('--rotateY', '0deg');
            });
        });

        // Optional: Add Intersection Observer for animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '50px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.animationPlayState = 'running';
                    observer.unobserve(entry.target);
                }
            });
        }, observerOptions);

        items.forEach(item => {
            item.style.animationPlayState = 'paused';
            observer.observe(item);
        });

    });
    jQuery(document).ready(function ($) {
        // Initialize Elementor lightbox
        const galleryItems = $('.modernpress-gallery-layout-1 .gallery-lightbox');

        if (galleryItems.length) {
            galleryItems.on('click', function (e) {
                if ($(this).data('elementor-open-lightbox') === 'yes') {
                    e.preventDefault();

                    const elements = [];
                    galleryItems.each(function () {
                        elements.push({
                            type: 'image',
                            url: $(this).attr('href'),
                            title: $(this).data('elementor-lightbox-title')
                        });
                    });

                    const lightbox = elementorFrontend.utils.lightbox;
                    lightbox.showModal({
                        type: 'slideshow',
                        modalOptions: {
                            id: 'elementor-lightbox-' + $('.modernpress-gallery-layout-1').data('id'),
                            entranceAnimation: '<?php echo esc_js($lightbox_animation); ?>',
                        },
                        slideshow: {
                            slides: elements,
                            swiper: {
                                initialSlide: $(this).index()
                            }
                        }
                    });
                }
            });
        }
    });