(function ($) {
    $(document).ready(function () {
        var $counter = $('.modernpress-counter-number');

        if ($counter.length) {
            var start = parseInt($counter.data('start'));
            var end = parseInt($counter.data('end'));
            var duration = $counter.data('duration');
            var decimals = $counter.data('decimals');
            var separator = $counter.data('separator') ? $counter.data('separator') : ',';
            var prefix = $counter.data('prefix') ? $counter.data('prefix') : '';
            var suffix = $counter.data('suffix') ? $counter.data('suffix') : '';

            $({ countNum: start }).animate({ countNum: end }, {
                duration: duration,
                easing: 'linear',
                step: function () {
                    // Format number with decimal places and separator
                    var countNum = this.countNum;
                    var formatted = countNum.toFixed(decimals);

                    if (separator) {
                        formatted = formatted.replace(/\B(?=(\d{3})+(?!\d))/g, separator);
                    }

                    $counter.text(prefix + formatted + suffix);
                },
                complete: function () {
                    $counter.text(prefix + this.countNum + suffix);
                }
            });
        }
    });
})(jQuery);
