 document.addEventListener('DOMContentLoaded', function () {
        // Mark the document as having JS enabled
        document.documentElement.classList.remove('no-js');

        // Optional: Add hover effects for touch devices
        if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
            const logoItems = document.querySelectorAll('.modernpress-client-logos-layout-3 .logo-item');

            logoItems.forEach(item => {
                item.addEventListener('touchstart', function () {
                    this.classList.add('touch-active');
                });

                item.addEventListener('touchend', function () {
                    setTimeout(() => {
                        this.classList.remove('touch-active');
                    }, 300);
                });
            });
        }
    });

    // layout 4 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Optional: Add intersection observer for animation on scroll
        if ('IntersectionObserver' in window) {
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.animationPlayState = 'running';
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.1
            });

            document.querySelectorAll('.modernpress-client-logos-layout-4 .logo-item').forEach(item => {
                item.style.animationPlayState = 'paused';
                observer.observe(item);
            });
        }
    });

    // layout 5 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Add intersection observer for animation on scroll
        if ('IntersectionObserver' in window) {
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.animationPlayState = 'running';
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.1,
                rootMargin: '50px'
            });

            document.querySelectorAll('.modernpress-client-logos-layout-5 .logo-item').forEach(item => {
                item.style.animationPlayState = 'paused';
                observer.observe(item);
            });
        }
    });