document.addEventListener('DOMContentLoaded', function () {
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-1');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation between items
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.addEventListener('keydown', (e) => {
                    let targetIndex;

                    switch (e.key) {
                        case 'ArrowUp':
                        case 'ArrowLeft':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                        case 'ArrowRight':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                        default:
                            return;
                    }

                    e.preventDefault();
                    headers[targetIndex].focus();
                });
            });
        });

        // Optional: Add resize observer to handle dynamic content changes
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        // Observe all accordion content elements
        document.querySelectorAll('.modernpress-accordion-layout-1 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });

    // accordion widget layout 2 js 

    document.addEventListener('DOMContentLoaded', function () {
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-2');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation between items
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.addEventListener('keydown', (e) => {
                    let targetIndex;

                    switch (e.key) {
                        case 'ArrowUp':
                        case 'ArrowLeft':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                        case 'ArrowRight':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                        default:
                            return;
                    }

                    e.preventDefault();
                    headers[targetIndex].focus();
                });
            });
        });

        // Optional: Add resize observer to handle dynamic content changes
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        // Observe all accordion content elements
        document.querySelectorAll('.modernpress-accordion-layout-2 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });

    // accordion layout 3 js 

    document.addEventListener('DOMContentLoaded', function () {
        // Same JavaScript as layout-1
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-3');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation between items
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.addEventListener('keydown', (e) => {
                    let targetIndex;

                    switch (e.key) {
                        case 'ArrowUp':
                        case 'ArrowLeft':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                        case 'ArrowRight':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                        default:
                            return;
                    }

                    e.preventDefault();
                    headers[targetIndex].focus();
                });
            });
        });

        // Optional: Add resize observer to handle dynamic content changes
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        // Observe all accordion content elements
        document.querySelectorAll('.modernpress-accordion-layout-3 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });

    // accordion layout 4 js 

    document.addEventListener('DOMContentLoaded', function () {
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-4');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation between items
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.addEventListener('keydown', (e) => {
                    let targetIndex;

                    switch (e.key) {
                        case 'ArrowUp':
                        case 'ArrowLeft':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                        case 'ArrowRight':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                        default:
                            return;
                    }

                    e.preventDefault();
                    headers[targetIndex].focus();
                });
            });
        });

        // Optional: Add resize observer to handle dynamic content changes
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        // Observe all accordion content elements
        document.querySelectorAll('.modernpress-accordion-layout-4 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });

    // accordion layout 5 js 

    document.addEventListener('DOMContentLoaded', function () {
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-5');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.setAttribute('tabindex', '0');
                header.setAttribute('role', 'button');
                header.setAttribute('aria-expanded', header.parentElement.classList.contains('active'));

                header.addEventListener('keydown', (e) => {
                    let targetIndex = -1;

                    switch (e.key) {
                        case 'ArrowUp':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                    }

                    if (targetIndex !== -1) {
                        e.preventDefault();
                        headers[targetIndex].focus();
                    }
                });
            });
        });

        // Optional: Handle dynamic content resizing
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        document.querySelectorAll('.modernpress-accordion-layout-5 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });

    // accordion layout 6 js 

    document.addEventListener('DOMContentLoaded', function () {
        const accordions = document.querySelectorAll('.modernpress-accordion-layout-6');

        accordions.forEach(accordion => {
            const items = accordion.querySelectorAll('.accordion-item');
            const multipleOpen = accordion.dataset.multiple === 'true';

            items.forEach(item => {
                const header = item.querySelector('.accordion-header');
                const content = item.querySelector('.accordion-content');

                // Initialize content height for active items
                if (item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }

                header.addEventListener('click', () => {
                    const isActive = item.classList.contains('active');

                    if (!multipleOpen) {
                        // Close other items
                        items.forEach(otherItem => {
                            if (otherItem !== item && otherItem.classList.contains('active')) {
                                otherItem.classList.remove('active');
                                otherItem.querySelector('.accordion-content').style.maxHeight = null;
                            }
                        });
                    }

                    // Toggle current item
                    item.classList.toggle('active');

                    if (!isActive) {
                        content.style.maxHeight = content.scrollHeight + 'px';
                    } else {
                        content.style.maxHeight = null;
                    }
                });

                // Keyboard accessibility
                header.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        header.click();
                    }
                });
            });

            // Add keyboard navigation between items
            const headers = accordion.querySelectorAll('.accordion-header');
            headers.forEach((header, index) => {
                header.addEventListener('keydown', (e) => {
                    let targetIndex;

                    switch (e.key) {
                        case 'ArrowUp':
                        case 'ArrowLeft':
                            targetIndex = index > 0 ? index - 1 : headers.length - 1;
                            break;
                        case 'ArrowDown':
                        case 'ArrowRight':
                            targetIndex = index < headers.length - 1 ? index + 1 : 0;
                            break;
                        case 'Home':
                            targetIndex = 0;
                            break;
                        case 'End':
                            targetIndex = headers.length - 1;
                            break;
                        default:
                            return;
                    }

                    e.preventDefault();
                    headers[targetIndex].focus();
                });
            });
        });

        // Optional: Add resize observer to handle dynamic content changes
        const resizeObserver = new ResizeObserver(entries => {
            entries.forEach(entry => {
                const content = entry.target;
                const item = content.closest('.accordion-item');

                if (item && item.classList.contains('active')) {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
            });
        });

        // Observe all accordion content elements
        document.querySelectorAll('.modernpress-accordion-layout-6 .accordion-content').forEach(content => {
            resizeObserver.observe(content);
        });
    });