<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <div class="main-admin-dash-modernpress">
        <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/header-tabs.php'; ?>

        <form method="post" action="options.php">
            <?php settings_fields('modernpress_settings_group'); ?>

            <div class="settings-section">
                <div class="modernpress-admin-widget-tab-heading">
                    <h3>Widgets</h3>
                    <div style="display: flex; gap: 10px;">
                        <button type="button" id="deactivate-all-widgets" class="button button-deactivate-all-widgets">
                            Deactivate All
                        </button>
                        <button type="button" id="activate-all-widgets" class="button button-activate-all-widgets">
                            Activate All
                        </button>
                    </div>
                </div>

                <div class="admin-widgets-tab">
                    <!-- <?php foreach ($all_widgets as $widget_id => $widget): ?>
                        <div class="admin-widgets-tab-widget">
                            <div class="modernpress-widget-icon"
                                style="background-image: url('<?php echo esc_url(plugin_dir_url(dirname(dirname(__FILE__))) . 'assets/icons/' . $widget['icon']); ?>');">
                            </div>

                            <div class="inside-admin-widgets-tab-widget">
                                <div class="widget-info">
                                    <p class="widget-name"><?php echo esc_html($widget['name']); ?></p>
                                    <p class="widget-description"><?php echo esc_html($widget['description']); ?></p>
                                </div>
                                <label class="settings-option modernpress-switch">
                                    <input type="checkbox" class="widget-checkbox" name="modernpress_activated_widgets[]"
                                        value="<?php echo esc_attr($widget_id); ?>" <?php checked(in_array($widget_id, $active_widgets)); ?> />
                                    <span class="modernpress-slider round"></span>
                                </label>
                            </div>
                        </div>
                    <?php endforeach; ?> -->
                    <!-- In widgets.php -->
                    <?php foreach ($data['all_widgets'] as $widget_id => $widget): ?>
                        <div class="admin-widgets-tab-widget">
                            <div class="modernpress-widget-icon"
                                style="background-image: url('<?php echo esc_url(plugin_dir_url(dirname(dirname(__FILE__))) . 'assets/icons/' . $widget['icon']); ?>');">
                            </div>

                            <div class="inside-admin-widgets-tab-widget">
                                <div class="widget-info">
                                    <p class="widget-name"><?php echo esc_html($widget['name']); ?></p>
                                    <p class="widget-description"><?php echo esc_html($widget['description']); ?></p>
                                </div>
                                <label class="settings-option modernpress-switch">
                                    <input type="checkbox" class="widget-checkbox" name="modernpress_activated_widgets[]"
                                        value="<?php echo esc_attr($widget_id); ?>" <?php checked(in_array($widget_id, $data['active_widgets'])); ?> />
                                    <span class="modernpress-slider round"></span>
                                </label>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <p class="submit">
                <input type="submit" name="submit" id="submit" class="button button-save-changes"
                    value="<?php esc_attr_e('Save Changes', 'modernpress-addons'); ?>" />
            </p>
        </form>
    </div>

    <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/sidebar.php'; ?>
</div>