<?php
if (!defined('ABSPATH')) {
    exit;
}

// Make sure to include the import/export functions
require_once MODERNPRESS_PLUGIN_DIR . 'admin/include/direct-export-import.php';

// Initialize a variable to track if import was attempted
$import_attempted = false;

// Process import if submitted
if (isset($_POST['modernpress_direct_import']) && isset($_POST['_wpnonce'])) {
    if (isset($_POST['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'modernpress_direct_import_nonce')) {

        $import_attempted = true;
        // The function will directly display success/error messages
        $import_success = modernpress_process_direct_import();
    } else {
        echo '<div class="notice notice-error is-dismissible"><p>' .
            esc_html__('Security check failed. Please try again.', 'modernpress-addons') .
            '</p></div>';
    }
}
?>

<div class="wrap">
    <div class="main-admin-dash-modernpress">
        <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/header-tabs.php'; ?>

        <div class="settings-section">
            <h3><?php esc_html_e('Import/Export Settings', 'modernpress-addons'); ?></h3>

            <!-- Export Section -->
            <div class="tool-section">
                <h4><?php esc_html_e('Export Settings', 'modernpress-addons'); ?></h4>
                <p><?php esc_html_e('Export your widget settings and configurations to a JSON file.', 'modernpress-addons'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=modernpress-tools&action=export&_wpnonce=' . wp_create_nonce('modernpress_export_nonce'))); ?>"
                    class="button button-primary">
                    <?php esc_html_e('Export Settings', 'modernpress-addons'); ?>
                </a>
            </div>

            <!-- Import Section -->
            <div class="tool-section">
                <h4><?php esc_html_e('Import Settings', 'modernpress-addons'); ?></h4>
                <p><?php esc_html_e('Import your previously exported settings file.', 'modernpress-addons'); ?></p>

                <form method="post" enctype="multipart/form-data">
                    <?php wp_nonce_field('modernpress_direct_import_nonce'); ?>
                    <p>
                        <input type="file" name="modernpress_import_file" accept=".json" required />
                    </p>
                    <p class="description">
                        <?php esc_html_e('Only .json files exported from ModernPress are supported.', 'modernpress-addons'); ?>
                    </p>
                    <p>
                        <input type="submit" name="modernpress_direct_import" class="button button-primary"
                            value="<?php esc_attr_e('Import Settings', 'modernpress-addons'); ?>" />
                    </p>
                </form>

                <div class="import-instructions">
                    <h4><?php esc_html_e('Having trouble importing?', 'modernpress-addons'); ?></h4>
                    <ol>
                        <li><?php esc_html_e('Make sure you are using a file previously exported from ModernPress.', 'modernpress-addons'); ?>
                        </li>
                        <li><?php esc_html_e('Check that the file is a valid JSON file.', 'modernpress-addons'); ?></li>
                        <li><?php esc_html_e('Try using a smaller export file (with fewer widgets activated).', 'modernpress-addons'); ?>
                        </li>
                        <li><?php esc_html_e('Ensure your server allows file uploads and has sufficient upload limits.', 'modernpress-addons'); ?>
                        </li>
                    </ol>
                </div>

                <?php if ($import_attempted && isset($import_success) && !$import_success): ?>
                    <div class="server-info">
                        <h4><?php esc_html_e('Server Information', 'modernpress-addons'); ?></h4>
                        <ul>
                            <li><?php echo esc_html__('Max upload size:', 'modernpress-addons') . ' ' . esc_html(size_format(wp_max_upload_size())); ?>
                            </li>
                            <li><?php echo esc_html__('PHP version:', 'modernpress-addons') . ' ' . esc_html(PHP_VERSION); ?>
                            </li>
                            <li><?php
                            $post_max_size = ini_get('post_max_size');
                            $upload_max_filesize = ini_get('upload_max_filesize');
                            echo esc_html__('PHP post_max_size:', 'modernpress-addons') . ' ' . esc_html($post_max_size);
                            echo '<br>';
                            echo esc_html__('PHP upload_max_filesize:', 'modernpress-addons') . ' ' . esc_html($upload_max_filesize);
                            ?></li>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/sidebar.php'; ?>
</div>