<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <div class="main-admin-dash-modernpress">
        <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/header-tabs.php'; ?>

        <div class="settings-section">
            <h3><?php esc_html_e('Support Resources', 'modernpress-addons'); ?></h3>

            <!-- Documentation Section -->
            <div class="support-section">
                <h4><?php esc_html_e('Documentation', 'modernpress-addons'); ?></h4>
                <p><?php esc_html_e('Check our detailed documentation for help with setting up and using ModernPress.', 'modernpress-addons'); ?>
                </p>
                <a href="https://modernpress.io/documentation/" target="_blank" class="button button-secondary">
                    <?php esc_html_e('View Documentation', 'modernpress-addons'); ?>
                </a>
            </div>

            <!-- System Information -->
            <div class="support-section">
                <h4><?php esc_html_e('System Information', 'modernpress-addons'); ?></h4>
                <table class="widefat" style="margin-top: 10px;">
                    <tr>
                        <td><?php esc_html_e('WordPress Version:', 'modernpress-addons'); ?></td>
                        <td><?php echo esc_html($data['system_info']['wordpress_version']); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('PHP Version:', 'modernpress-addons'); ?></td>
                        <td><?php echo esc_html($data['system_info']['php_version']); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('MySQL Version:', 'modernpress-addons'); ?></td>
                        <td><?php echo esc_html($data['system_info']['mysql_version']); ?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Plugin Version:', 'modernpress-addons'); ?></td>
                        <td><?php echo esc_html($data['system_info']['plugin_version']); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/sidebar.php'; ?>
</div>