<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <div class="main-admin-dash-modernpress">
        <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/header-tabs.php'; ?>

        <form method="post" action="">
            <?php wp_nonce_field('modernpress_settings_action', 'modernpress_settings_nonce'); ?>
            
            <div class="settings-section">
                <h3><?php esc_html_e('General Settings', 'modernpress-addons'); ?></h3>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="css_loading"><?php esc_html_e('CSS Loading Method', 'modernpress-addons'); ?></label>
                        </th>
                        <td>
                            <select name="modernpress_settings[css_loading]" id="css_loading">
                                <option value="inline" <?php selected(isset($settings['css_loading']) ? $settings['css_loading'] : '', 'inline'); ?>>
                                    <?php esc_html_e('Inline', 'modernpress-addons'); ?>
                                </option>
                                <option value="file" <?php selected(isset($settings['css_loading']) ? $settings['css_loading'] : '', 'file'); ?>>
                                    <?php esc_html_e('External File', 'modernpress-addons'); ?>
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <?php esc_html_e('Enable Features', 'modernpress-addons'); ?>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" 
                                       name="modernpress_settings[enable_animation]" 
                                       value="1" 
                                       <?php checked(isset($settings['enable_animation']) ? $settings['enable_animation'] : 0); ?>>
                                <?php esc_html_e('Enable Animations', 'modernpress-addons'); ?>
                            </label>
                        </td>
                    </tr>
                </table>
            </div>

            <p class="submit">
                <input type="submit" name="submit" class="button button-primary" 
                       value="<?php esc_attr_e('Save Settings', 'modernpress-addons'); ?>" />
            </p>
        </form>
    </div>

    <?php include MODERNPRESS_PLUGIN_DIR . 'admin/views/partials/sidebar.php'; ?>
</div>