<?php
if (!defined('ABSPATH')) {
    exit;
}

use ModernPress\Admin\Admin_Helper;

$active_widgets = Admin_Helper::get_active_widgets();
$all_widgets = Admin_Helper::get_all_widgets();
?>

<div class="main-admin-dash-sidebar">
    <div class="modern-press-admin-sidebar-section">
        <h2><?php esc_html_e('Welcome to ModernPress', 'modernpress-addons'); ?></h2>
        <p><?php esc_html_e('Thank you for using ModernPress. Here you can manage your widgets, builders, tools, and more to customize your site.', 'modernpress-addons'); ?>
        </p>

        <div class="modern-press-buttons">
            <a href="https://modernpress.io/" class="button button-create-header-footer">
                <?php esc_html_e('Live Preview', 'modernpress-addons'); ?>
            </a>
            <a href="https://umars-organization-7.gitbook.io/modernpress" target="_blank"
                class="button button-read-documentation">
                <?php esc_html_e('Read Documentation', 'modernpress-addons'); ?>
            </a>
        </div>
    </div>

    <div class="modern-press-admin-sidebar-section">
        <h3><?php esc_html_e('Widgets Overview', 'modernpress-addons'); ?></h3>
        <ul class="modernpress-admin-widgets-stats">
            <li class="modernpress-admin-widgets-stats-item total-widgets">
                <strong><?php echo count($all_widgets); ?></strong>
                <br><?php esc_html_e('Widgets', 'modernpress-addons'); ?>
            </li>
            <li class="modernpress-admin-widgets-stats-item active-widgets">
                <strong><?php echo count($active_widgets); ?></strong>
                <br><?php esc_html_e('Active', 'modernpress-addons'); ?>
            </li>
            <li class="modernpress-admin-widgets-stats-item inactive-widgets">
                <strong><?php echo count($all_widgets) - count($active_widgets); ?></strong>
                <br><?php esc_html_e('Inactive', 'modernpress-addons'); ?>
            </li>
        </ul>
    </div>

    <div class="modern-press-admin-sidebar-section">
        <h3><?php esc_html_e('Quick Access', 'modernpress-addons'); ?></h3>
        <ul class="modernpress-admin-quicklinks">
            <!-- <li class="modernpress-admin-quicklinks-item">
                <a href="https://modernpress.com/contact">
                    <span>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                          
                        </svg>
                        <?php esc_html_e('Contact Us', 'modernpress-addons'); ?>
                    </span>
                    <svg width="10" height="15" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="#0C20E1" stroke-width="1.25"
                            stroke-miterlimit="16" />
                    </svg>
                </a>
            </li> -->
            <li class="modernpress-admin-quicklinks-item">
                <a href="https://modernpress.io/contact-us/">
                    <span style="display: flex; align-items: center; gap: 6px;">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M15.8332 7.50317L16.1794 6.98283C15.9929 6.85875 15.7543 6.84395 15.5539 6.94405L15.8332 7.50317ZM18.3332 9.16653H18.9582C18.9582 8.95736 18.8535 8.76205 18.6794 8.64619L18.3332 9.16653ZM18.3332 12.4999L18.6799 13.0199C18.8537 12.904 18.9582 12.7088 18.9582 12.4999H18.3332ZM14.1665 13.3307H13.5415V13.7164L13.8863 13.8894L14.1665 13.3307ZM15.8332 14.1665L15.553 14.7252C15.7537 14.8259 15.993 14.8111 16.1799 14.6866L15.8332 14.1665ZM14.1665 8.3357L13.8872 7.77657L13.5415 7.94926V8.3357H14.1665ZM14.7915 13.3307V8.3357H13.5415V13.3307H14.7915ZM15.487 8.02352L17.987 9.68688L18.6794 8.64619L16.1794 6.98283L15.487 8.02352ZM17.7082 9.16653V12.4999H18.9582V9.16653H17.7082ZM13.8863 13.8894L15.553 14.7252L16.1134 13.6079L14.4467 12.772L13.8863 13.8894ZM14.4458 8.89482L16.1125 8.0623L15.5539 6.94405L13.8872 7.77657L14.4458 8.89482ZM17.9865 11.9798L15.4865 13.6465L16.1799 14.6866L18.6799 13.0199L17.9865 11.9798Z"
                                fill="#1A1A1A" />
                            <path
                                d="M5.83317 13.3307L6.11335 13.8894L6.45817 13.7164V13.3307H5.83317ZM5.83317 8.3357H6.45817V7.94926L6.11246 7.77657L5.83317 8.3357ZM4.1665 7.50317L4.4458 6.94405C4.24541 6.84395 4.00678 6.85875 3.82029 6.98283L4.1665 7.50317ZM1.6665 9.16653L1.32029 8.64619C1.14614 8.76205 1.0415 8.95736 1.0415 9.16653H1.6665ZM1.6665 12.4999H1.0415C1.0415 12.7088 1.14594 12.904 1.31982 13.0199L1.6665 12.4999ZM4.1665 14.1665L3.81982 14.6866C4.00666 14.8111 4.24596 14.8259 4.44669 14.7252L4.1665 14.1665ZM6.45817 13.3307V8.3357H5.20817V13.3307H6.45817ZM3.82029 6.98283L1.32029 8.64619L2.01271 9.68688L4.51271 8.02352L3.82029 6.98283ZM1.0415 9.16653V12.4999H2.2915V9.16653H1.0415ZM5.55299 12.772L3.88632 13.6079L4.44669 14.7252L6.11335 13.8894L5.55299 12.772ZM6.11246 7.77657L4.4458 6.94405L3.88721 8.0623L5.55388 8.89482L6.11246 7.77657ZM1.31982 13.0199L3.81982 14.6866L4.51319 13.6465L2.01319 11.9798L1.31982 13.0199Z"
                                fill="#1A1A1A" />
                            <path
                                d="M4.1665 7.5C4.1665 4.73858 6.77818 2.5 9.99984 2.5C13.2215 2.5 15.8332 4.73858 15.8332 7.5"
                                stroke="#1A1A1A" stroke-width="1.25" stroke-linejoin="round" />
                            <path d="M15.8333 14.1665V17.4998H10" stroke="#1A1A1A" stroke-width="1.25"
                                stroke-linejoin="round" />
                        </svg>
                        Contact Us
                    </span>
                    <svg width="10" height="15" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="#0C20E1" stroke-width="1.25"
                            stroke-miterlimit="16" />
                    </svg>
                </a>
            </li>
            <li class="modernpress-admin-quicklinks-item">
                <a href="https://modernpress.io/documentation/">
                    <span>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9.99984" cy="10.0001" r="8.33333" stroke="#1A1A1A" stroke-width="1.25"
                                stroke-linecap="square" stroke-linejoin="round" />
                            <path
                                d="M7.9165 8.33333C7.9165 7.18274 8.84924 6.25 9.99984 6.25C11.1504 6.25 12.0832 7.18274 12.0832 8.33333C12.0832 9.48393 11.1504 10.4167 9.99984 10.4167V12.0833M9.99984 13.3333V14.5833"
                                stroke="#1A1A1A" stroke-width="1.25" />
                        </svg>
                        Help Center
                    </span>
                    <svg width="10" height="15" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="#0C20E1" stroke-width="1.25"
                            stroke-miterlimit="16" />
                    </svg>
                </a>
            </li>
            <li class="modernpress-admin-quicklinks-item">
                <a href="">
                    <span>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M9.99959 2.08325L10.3211 1.54731C10.1232 1.42856 9.87595 1.42856 9.67803 1.54732L9.99959 2.08325ZM18.3332 7.08325H18.9582V6.72938L18.6547 6.54731L18.3332 7.08325ZM18.3332 17.9166V18.5416C18.6783 18.5416 18.9582 18.2618 18.9582 17.9166H18.3332ZM1.6665 17.9166H1.0415C1.0415 18.2618 1.32133 18.5416 1.6665 18.5416L1.6665 17.9166ZM1.6665 7.08325L1.34494 6.54732L1.0415 6.72939V7.08325H1.6665ZM18.6547 6.54731L10.3211 1.54731L9.67804 2.61919L18.0116 7.61919L18.6547 6.54731ZM17.7082 7.08325V17.9166H18.9582V7.08325H17.7082ZM18.3332 17.2916H1.6665V18.5416H18.3332V17.2916ZM2.2915 17.9166V7.08325H1.0415V17.9166H2.2915ZM1.98807 7.61918L10.3212 2.61918L9.67803 1.54732L1.34494 6.54732L1.98807 7.61918Z"
                                fill="#1A1A1A" />
                            <path d="M1.6665 7.08325L8.33317 12.0833M18.3332 7.08325L11.6665 12.0833" stroke="#1A1A1A"
                                stroke-width="1.25" stroke-linejoin="round" />
                            <path d="M1.6665 17.5L9.99984 11.25L18.3332 17.5" stroke="#1A1A1A" stroke-width="1.25" />
                        </svg>
                        Our Newsletter
                    </span>
                    <svg width="10" height="15" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="#0C20E1" stroke-width="1.25"
                            stroke-miterlimit="16" />
                    </svg>
                </a>
            </li>
            <li class="modernpress-admin-quicklinks-item">
                <a href="https://modernpress.io/contact-us/">
                    <span>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M2.9165 1.66675L2.9165 1.04175C2.57133 1.04175 2.2915 1.32157 2.2915 1.66675L2.9165 1.66675ZM17.0832 1.66675H17.7082C17.7082 1.32157 17.4283 1.04175 17.0832 1.04175V1.66675ZM2.9165 18.3334H2.2915C2.2915 18.4992 2.35735 18.6581 2.47456 18.7754C2.59177 18.8926 2.75074 18.9584 2.9165 18.9584V18.3334ZM11.2498 18.3334V18.9584H11.5087L11.6918 18.7754L11.2498 18.3334ZM17.0832 12.5001L17.5251 12.942L17.7082 12.759V12.5001H17.0832ZM11.2498 12.5001V11.8751H10.6248V12.5001H11.2498ZM2.9165 2.29175L17.0832 2.29175V1.04175L2.9165 1.04175L2.9165 2.29175ZM3.5415 18.3334L3.5415 1.66675L2.2915 1.66675L2.2915 18.3334H3.5415ZM2.9165 18.9584H11.2498V17.7084H2.9165V18.9584ZM17.7082 12.5001V1.66675H16.4582V12.5001H17.7082ZM11.6918 18.7754L17.5251 12.942L16.6412 12.0581L10.8079 17.8915L11.6918 18.7754ZM11.8748 18.3334V12.5001H10.6248V18.3334H11.8748ZM11.2498 13.1251H17.0832V11.8751H11.2498V13.1251Z"
                                fill="#1A1A1A" />
                            <path d="M6.6665 5.8335H13.3332" stroke="#1A1A1A" stroke-width="1.25"
                                stroke-linejoin="round" />
                            <path d="M6.6665 9.16675H9.99984" stroke="#1A1A1A" stroke-width="1.25"
                                stroke-linejoin="round" />
                        </svg>
                        Request a Widget
                    </span>
                    <svg width="10" height="15" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.500039 1L5.5 6.00004L0.5 11" stroke="#0C20E1" stroke-width="1.25"
                            stroke-miterlimit="16" />
                    </svg>
                </a>
            </li>
            <!-- Add more quick access links as needed -->
        </ul>
    </div>
</div>