<?php
if (!defined('ABSPATH')) {
    exit;
}

// Add nonce field to the URL
$nonce = wp_create_nonce('modernpress_tab_nonce');

// Verify nonce
if (isset($_GET['_wpnonce']) && !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'modernpress_tab_nonce')) {
    wp_die(esc_html__('Security check failed', 'modernpress-addons'));
}

// Safely get and unslash the current page
$current_page = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : '';
?>

<h2 class="nav-tab-wrapper modernpress-panel-tabs">
    <a href="<?php echo esc_url(add_query_arg(array('page' => 'modernpress-widgets', '_wpnonce' => $nonce), admin_url('admin.php'))); ?>"
        class="nav-tab <?php echo $current_page === 'modernpress-widgets' ? 'nav-tab-active' : ''; ?>">
        <?php esc_html_e('Widgets', 'modernpress-addons'); ?>
    </a>
    <!-- <a href="<?php echo esc_url(add_query_arg(array('page' => 'modernpress-settings', '_wpnonce' => $nonce), admin_url('admin.php'))); ?>"
        class="nav-tab <?php echo $current_page === 'modernpress-settings' ? 'nav-tab-active' : ''; ?>">
        <?php esc_html_e('Settings', 'modernpress-addons'); ?>
    </a> -->
    <a href="<?php echo esc_url(add_query_arg(array('page' => 'modernpress-tools', '_wpnonce' => $nonce), admin_url('admin.php'))); ?>"
        class="nav-tab <?php echo $current_page === 'modernpress-tools' ? 'nav-tab-active' : ''; ?>">
        <?php esc_html_e('Tools', 'modernpress-addons'); ?>
    </a>
    <a href="<?php echo esc_url(add_query_arg(array('page' => 'modernpress-support', '_wpnonce' => $nonce), admin_url('admin.php'))); ?>"
        class="nav-tab <?php echo $current_page === 'modernpress-support' ? 'nav-tab-active' : ''; ?>">
        <?php esc_html_e('Support', 'modernpress-addons'); ?>
    </a>
</h2>