<?php
namespace ModernPress\Admin\Pages;

use ModernPress\Admin\Admin_Helper;

if (!defined('ABSPATH')) {
    exit;
}

class Widgets_Page
{
    public function get_title()
    {
        return __('ModernPress Widgets', 'modernpress-addons');
    }

    public function get_menu_title()
    {
        return __('Widgets', 'modernpress-addons');
    }

    public function render()
    {
        if (!current_user_can('manage_options')) {
            return;
        }

        $this->handle_form_submission();

        $data = [
            'all_widgets' => Admin_Helper::get_all_widgets(),
            'active_widgets' => Admin_Helper::get_active_widgets()
        ];

        $this->load_template('widgets', $data);
    }

    private function handle_form_submission()
    {
        if (!isset($_POST['submit'])) {
            return;
        }

        check_admin_referer('modernpress_widgets_action', 'modernpress_widgets_nonce');

        if (isset($_POST['bulk_action'])) {
            $bulk_action = sanitize_key(wp_unslash($_POST['bulk_action']));
            $this->handle_bulk_action($bulk_action);
            return;
        }

        if (isset($_POST['modernpress_activated_widgets'])) {
            // Unsplash the input before sanitization
            $activated_widgets = array_map('sanitize_text_field', wp_unslash($_POST['modernpress_activated_widgets']));
            update_option('modernpress_activated_widgets', $activated_widgets);
        }
    }

    private function handle_bulk_action($action)
    {
        if ($action === 'activate') {
            update_option('modernpress_activated_widgets', array_keys(Admin_Helper::get_all_widgets()));
        } elseif ($action === 'deactivate') {
            update_option('modernpress_activated_widgets', []);
        }
    }

    private function load_template($template, $data = [])
    {
        // Access variables directly from $data instead of extracting
        include MODERNPRESS_PLUGIN_DIR . 'admin/views/' . $template . '.php';
    }
}
