<?php
namespace ModernPress\Admin\Pages;

use ModernPress\Admin\Admin_Helper;

if (!defined('ABSPATH')) {
    exit;
}

class Tools_Page
{
    public function get_title()
    {
        return __('ModernPress Tools', 'modernpress-addons');
    }

    public function get_menu_title()
    {
        return __('Tools', 'modernpress-addons');
    }

    public function render()
    {
        if (!current_user_can('manage_options')) {
            return;
        }

        // Check for direct export action
        if (isset($_GET['action']) && $_GET['action'] === 'export' && isset($_GET['_wpnonce'])) {
            if (isset($_GET['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'modernpress_export_nonce')) {
                $this->direct_export_settings();
            }
        }

        // Load direct export-import functions
        require_once MODERNPRESS_PLUGIN_DIR . 'admin/include/direct-export-import.php';

        // Directly include the template without passing data
        include MODERNPRESS_PLUGIN_DIR . 'admin/views/tools.php';
    }

    /**
     * Direct export settings to a JSON file
     */
    private function direct_export_settings()
    {
        // Get export data
        $active_widgets = Admin_Helper::get_active_widgets();
        $settings = get_option('modernpress_settings', []);

        $data = array(
            'widgets' => $active_widgets,
            'settings' => $settings
        );

        // Convert to JSON
        $json = wp_json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

        if ($json === false) {
            wp_die(esc_html__('Error encoding settings to JSON.', 'modernpress-addons'));

        }

        // Force download
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename=modernpress-settings-' . gmdate('Y-m-d') . '.json');
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');
        header('Content-Length: ' . strlen($json));

        // Send JSON response
        wp_send_json($data);
    }
}