<?php
namespace ModernPress\Admin\Pages;

use ModernPress\Admin\Admin_Helper;

if (!defined('ABSPATH')) {
    exit;
}

class Support_Page
{
    public function get_title()
    {
        return __('ModernPress Support', 'modernpress-addons');
    }

    public function get_menu_title()
    {
        return __('Support', 'modernpress-addons');
    }

    public function render()
    {
        if (!current_user_can('manage_options')) {
            return;
        }

        $data = [
            'system_info' => $this->get_system_info()
        ];

        $this->load_template('support', $data);
    }

    private function get_system_info()
    {
        global $wpdb;

        // Properly handle SERVER_SOFTWARE with validation, unslashing, and sanitization
        $server_software = 'Unknown';
        if (isset($_SERVER['SERVER_SOFTWARE'])) {
            $server_software = sanitize_text_field(wp_unslash($_SERVER['SERVER_SOFTWARE']));
        }

        return [
            'wordpress_version' => get_bloginfo('version'),
            'php_version' => PHP_VERSION,
            'mysql_version' => $wpdb->db_version(),
            'server_software' => $server_software,
            'plugin_version' => MODERNPRESS_VERSION,
            'active_theme' => wp_get_theme()->get('Name'),
            'active_plugins' => get_option('active_plugins')
        ];
    }

    private function load_template($template, $data = [])
    {
        // Access variables directly from $data instead of extracting
        include MODERNPRESS_PLUGIN_DIR . 'admin/views/' . $template . '.php';
    }
}