<?php
namespace ModernPress\Admin\Pages;

use ModernPress\Admin\Admin_Helper;

if (!defined('ABSPATH')) {
    exit;
}

class Settings_Page
{
    public function get_title()
    {
        return __('ModernPress Settings', 'modernpress-addons');
    }

    public function get_menu_title()
    {
        return __('Settings', 'modernpress-addons');
    }

    public function render()
    {
        if (!current_user_can('manage_options')) {
            return;
        }

        $this->handle_form_submission();

        $data = [
            'settings' => get_option('modernpress_settings', [])
        ];

        $this->load_template('settings', $data);
    }

    private function handle_form_submission()
    {
        if (!isset($_POST['submit'])) {
            return;
        }

        check_admin_referer('modernpress_settings_action', 'modernpress_settings_nonce');

        if (isset($_POST['modernpress_settings']) && is_array($_POST['modernpress_settings'])) {
            // Sanitize the array first
            $raw_settings = map_deep(wp_unslash($_POST['modernpress_settings']), 'sanitize_text_field');

            // Now update the option with sanitized data
            update_option('modernpress_settings', $raw_settings);
        }
    }

    private function load_template($template, $data = [])
    {
        // Access variables directly from $data instead of extracting
        include MODERNPRESS_PLUGIN_DIR . 'admin/views/' . $template . '.php';
    }
}