<?php
namespace ModernPress\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Admin_Helper
{
    /**
     * Get the current admin page
     * 
     * @return string
     */
    public static function get_current_page()
    {
        // Verify nonce with proper unslashing
        $nonce = isset($_REQUEST['_wpnonce']) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])), 'modernpress_admin_nonce') : false;

        if (!$nonce) {
            // If nonce verification fails, return default page
            return 'modernpress-widgets';
        }

        // Properly unslash and sanitize the page parameter
        return isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : 'modernpress-widgets';
    }

    /**
     * Get URL for a specific tab
     * 
     * @param string $tab
     * @return string
     */
    public static function get_tab_url($tab)
    {
        $args = [
            'page' => 'modernpress-' . $tab,
            '_wpnonce' => wp_create_nonce('modernpress_admin_nonce')
        ];

        return add_query_arg($args, admin_url('admin.php'));
    }

    /**
     * Check if the given tab is currently active
     * 
     * @param string $tab
     * @return boolean
     */
    public static function is_active_tab($tab)
    {
        $current_page = self::get_current_page();
        return $current_page === 'modernpress-' . $tab;
    }

    /**
     * Get all available widgets
     * 
     * @return array
     */
    public static function get_all_widgets()
    {
        return [
            'modernpress-icon-box' => [
                'name' => __('Icon Box', 'modernpress-addons'),
                'description' => __('stylish icon box', 'modernpress-addons'),
                'icon' => 'star-circle-svgrepo-com.svg'
            ],
            'modernpress-image-box' => [
                'name' => __('Image Box', 'modernpress-addons'),
                'description' => __('stylish image box', 'modernpress-addons'),
                'icon' => 'image-svgrepo-com.svg'
            ],
            'modernpress-dual-heading' => [
                'name' => __('Dual Heading', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'text-fields-svgrepo-com.svg'
            ],
            'modernpress-heading-block-heading' => [
                'name' => __('Heading block', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'header-svgrepo-com.svg'
            ],
            'modernpress-card-widget' => [
                'name' => __('Cards', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'spade-4-of-playing-cards-svgrepo-com.svg'
            ],
            'modernpress-posts-widget' => [
                'name' => __('Posts', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'paper-document-svgrepo-com.svg'
            ],
            'modernpress-gallery-widget' => [
                'name' => __('Gallery', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'gallery-grid-view-1403-svgrepo-com.svg'
            ],
            'modernpress-team-widget' => [
                'name' => __('Team', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'team-member-svgrepo-com.svg'
            ],
            'modernpress-slider-widget' => [
                'name' => __('Image Slider', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'image-slider-svgrepo-com.svg'
            ],
            'modernpress-content-block-widget' => [
                'name' => __('Content Block', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'content-inline-svgrepo-com.svg'
            ],
            'modernpress-accordian-widget' => [
                'name' => __('Accordion', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'accordion-menu-svgrepo-com.svg'
            ],
            'modernpress-category-tabs-widget' => [
                'name' => __('Categories', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'category-2-svgrepo-com.svg'
            ],
            'modernpress-tabs-widget' => [
                'name' => __('Tabs', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'tabs-svgrepo-com.svg'
            ],
            'modernpress-search-widget' => [
                'name' => __('Search', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'search-alt-2-svgrepo-com.svg'
            ],
            'modernpress-call-to-action-widget' => [
                'name' => __('CTA', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'click-bait-svgrepo-com.svg'
            ],
            'modernpress-logos-widget' => [
                'name' => __('Clients Logos', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'flag-svgrepo-com.svg'
            ],
            'modernpress-table-widget' => [
                'name' => __('Tables', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'table-list-svgrepo-com.svg'
            ],
            'modernpress-social-widget' => [
                'name' => __('Social Icons', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'share-svgrepo-com.svg'
            ],
            'modernprss-testimonial-widget' => [
                'name' => __('Testimonials', 'modernpress-addons'),
                'description' => __('Dynamic Counter Widget', 'modernpress-addons'),
                'icon' => 'customer-testimonial-svgrepo-com.svg'
            ],
        ];
    }

    /**
     * Get active widgets
     * 
     * @return array
     */
    public static function get_active_widgets()
    {
        return get_option('modernpress_activated_widgets', []);
    }
}