<?php
// admin/class-admin.php

namespace ModernPress\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Admin
{
    private $pages = [];
    private static $instance = null;

    // Singleton instance
    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct()
    {
        $this->load_dependencies();
        $this->init();
        // Add action to enqueue menu icon CSS globally
        add_action('admin_enqueue_scripts', [$this, 'enqueue_menu_icon_css']);
    }
    public function enqueue_menu_icon_css()
    {
        // This loads on all admin pages without checking the hook
        wp_enqueue_style(
            'modernpress-menu-icon',
            MODERNPRESS_PLUGIN_URL . 'admin/assets/css/menu-icon.css',
            [],
            MODERNPRESS_VERSION
        );
    }
    private function load_dependencies()
    {
        // Load core files
        require_once MODERNPRESS_PLUGIN_DIR . 'admin/include/class-admin-helper.php';

        // Load page classes
        require_once MODERNPRESS_PLUGIN_DIR . 'admin/pages/class-widgets-page.php';
        // require_once MODERNPRESS_PLUGIN_DIR . 'admin/pages/class-settings-page.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'admin/pages/class-tools-page.php';
        require_once MODERNPRESS_PLUGIN_DIR . 'admin/pages/class-support-page.php';
    }

    private function init()
    {
        // Initialize pages
        $this->pages = [
            'widgets' => new Pages\Widgets_Page(),
            // 'settings' => new Pages\Settings_Page(),
            'tools' => new Pages\Tools_Page(),
            'support' => new Pages\Support_Page(),
        ];

        // Add WordPress hooks
        add_action('admin_menu', [$this, 'register_menu_pages']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
        add_action('admin_init', [$this, 'register_settings']);
    }
    public function register_settings()
    {
        register_setting(
            'modernpress_settings_group',
            'modernpress_activated_widgets',
            array(
                'type' => 'array',
                'sanitize_callback' => array($this, 'sanitize_widget_settings')
            )
        );
    }
    public function sanitize_widget_settings($input)
    {
        if (!is_array($input)) {
            return array();
        }
        return array_map('sanitize_text_field', $input);
    }
    public function register_menu_pages()
    {
        // Add main menu
        add_menu_page(
            __('ModernPress', 'modernpress-addons'),
            __('ModernPress', 'modernpress-addons'),
            'manage_options',
            'modernpress-widgets',
            [$this->pages['widgets'], 'render'],
            plugin_dir_url(__FILE__) . 'assets/icons/site-logo.svg',
            25
        );


        // Add submenus
        foreach ($this->pages as $slug => $page) {
            add_submenu_page(
                'modernpress-widgets',
                $page->get_title(),
                $page->get_menu_title(),
                'manage_options',
                'modernpress-' . $slug,
                [$page, 'render']
            );
        }


    }



    public function enqueue_admin_assets($hook)
    {
        if (strpos($hook, 'modernpress') === false) {
            return;
        }
        wp_enqueue_style(
            'modernpress-font-inter',
            'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap',
            [],
            get_bloginfo('version') // Uses the site's WordPress version
        );

        wp_enqueue_style(
            'modernpress-admin',
            MODERNPRESS_PLUGIN_URL . 'admin/assets/css/admin-style.css',
            [],
            MODERNPRESS_VERSION
        );
        // Enqueue JavaScript
        wp_enqueue_script(
            'modernpress-admin',
            MODERNPRESS_PLUGIN_URL . 'admin/assets/js/admin-script.js',
            [],  // No dependencies needed for vanilla JS
            MODERNPRESS_VERSION,
            true  // Load in footer
        );
    }
}