jQuery(document).ready(function($) {
    // Tab click handler
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();

        // Remove active class from all tabs and contents
        $('.nav-tab').removeClass('nav-tab-active');
        $('.tab-content').removeClass('active');

        // Add active class to the clicked tab and its associated content
        $(this).addClass('nav-tab-active');
        $($(this).attr('href')).addClass('active'); // href points to the ID
    });
});

jQuery(document).ready(function($) {
    // Only prevent default for widget activation/deactivation controls
    $('.nav-tab').off('click'); // Remove any existing click handlers
    
    // Handle bulk widget actions
    const activateAllBtn = document.getElementById('activate-all-widgets');
    const deactivateAllBtn = document.getElementById('deactivate-all-widgets');
    const checkboxes = document.querySelectorAll('.widget-checkbox');

    if (activateAllBtn) {
        activateAllBtn.addEventListener('click', function () {
            checkboxes.forEach(checkbox => checkbox.checked = true);
        });
    }

    if (deactivateAllBtn) {
        deactivateAllBtn.addEventListener('click', function () {
            checkboxes.forEach(checkbox => checkbox.checked = false);
        });
    }
});