<?php
/**
 * Modern Pricing Table for Elementor
 * 
 * Plugin Name: Modern Pricing Table for Elementor
 * Description: Create simple but modern pricing tables with advanced customization options. Boost conversions with professional-grade designs that perfectly match your brand.
 * Version:	    1.0.1 
 * Author:    	Payment Addons, support@payaddons.com 
 * Author URI:	https://payaddons.com
 * Text Domain: modern-pricing-table-for-elementor
 * Text Domain: modern-pricing-table-for-elementor
 * License:     GPL v2 or later
 * License URI: https://opensource.org/licenses/GPL-3.0
 * Requires Plugins: elementor 
 * Elementor tested up to: 3.28.3
 * Elementor Pro tested up to: 3.28.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * Defining plugin constants.
 *
 * @since 1.0.0
 */
define('MPTE_PLUGIN_NAME', 'Modern Pricing Table for Elementor');
define('MPTE_PLUGIN_SLUG', 'modern-pricing-table-for-elementor');
define('MPTE_PLUGIN_VERSION', '1.0.0');
define('MPTE_PLUGIN_URL', 'https://payaddons.com/');
define('MPTE_ADDONS_PATH', trailingslashit(plugin_dir_path(__FILE__)));
define('MPTE_ADDONS_FILE', __FILE__);

require_once MPTE_ADDONS_PATH . '/bootstrap.php';

/**
 * Run plugin after all others plugins
 *
 * @since 1.0.0
 */
add_action( 'plugins_loaded', function() {
	\Modern_Pricing_Table\Bootstrap::instance();
} );

/**
 * Activation hook
 *
 * @since v1.0.0
 */
register_activation_hook(__FILE__, function () {
});