<?php

namespace Modern_Pricing_Table;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

final class Bootstrap
{
	const MINIMUM_ELEMENTOR_VERSION = '3.2.0';

	// instance container
	private static $_instance = null;

	public static function instance()
	{

		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function __construct()
	{
		if ( $this->is_compatible() ) {
			// register hooks
			$this->register_hooks();
		}
	}

	public function is_compatible() {

		// Check if Elementor is installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return false;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return false;
		}

		return true;

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {

		// if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		// $message = sprintf(
		// 	/* translators: 1: Plugin name 2: Elementor */
		// 	esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'modern-pricing-table-for-elementor' ),
		// 	'<strong>' . MPTE_PLUGIN_NAME . '</strong>',
		// 	'<strong>' . esc_html__( 'Elementor', 'modern-pricing-table-for-elementor' ) . '</strong>'
		// );

		// printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {

		// if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		// $message = sprintf(
		// 	/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
		// 	esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'modern-pricing-table-for-elementor' ),
		// 	'<strong>' . MPTE_PLUGIN_NAME . '</strong>',
		// 	'<strong>' . esc_html__( 'Elementor', 'modern-pricing-table-for-elementor' ) . '</strong>',
		// 	 self::MINIMUM_ELEMENTOR_VERSION
		// );

		// printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	protected function register_hooks()
	{
		add_action('wp_enqueue_scripts', [$this, 'register_widget_scripts']);
    add_action('elementor/elements/categories_registered', [$this, 'register_categories']);
		add_action('elementor/widgets/register', [$this, 'register_widgets']);
	}

	public function register_categories($elements_manager) {
		$elements_manager->add_category(
			'pay-addons',
			[
				'title' => esc_html__('Pay Addons', 'modern-pricing-table-for-elementor'),
				'icon' => 'fa fa-plug',
			]
		);
	}

	public function register_widgets( $widgets_manager ) {
		include MPTE_ADDONS_PATH . '/includes/pricing-table.php';

		$widgets_manager->register( new \Modern_Pricing_Table\Widgets\PricingTable() );
	}

	
  public function register_widget_scripts()
  {
      wp_register_style('modern-pricing-table-style', plugins_url('assets/css/pricing-table.css', __FILE__), [], MPTE_PLUGIN_VERSION);
			wp_enqueue_style('modern-pricing-table-style');
  }
}