<?php
/**
 * Plugin Name:       MNP Newsroom - Popular Posts
 * Plugin URI:        https://wordpress.org/plugins/mnp-newsroom-popular-posts/
 * Description:       A high-performance, secure, and modern popular posts widget. Features smart caching and anti-bot protection.
 * Version:           7.3.2
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            Leonardo Cofano (lcofano)
 * Author URI:        https://profiles.wordpress.org/lcofano/
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Donate link:       https://www.paypal.com/paypalme/lcofano
 * Text Domain:       mnp-newsroom-popular-posts
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 1. DEFINIR CONSTANTES (100% actualizadas a MNPN_)
define( 'MNPN_VERSION', '7.3.2' ); 
define( 'MNPN_PATH', plugin_dir_path( __FILE__ ) );
define( 'MNPN_URL', plugin_dir_url( __FILE__ ) );

// 2. CARGA DE ARCHIVOS
require_once MNPN_PATH . 'includes/mnp-api.php';
require_once MNPN_PATH . 'includes/mnp-public.php';

if ( is_admin() ) {
    require_once MNPN_PATH . 'includes/mnp-admin.php';
}

// 3. ACTIVACIÓN: CREAR TABLA
register_activation_hook( __FILE__, 'mnpn_activar_plugin' );

function mnpn_activar_plugin() {
    global $wpdb;
    $tabla = $wpdb->prefix . 'mnpn_log';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $tabla (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        post_id bigint(20) NOT NULL,
        fecha datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        PRIMARY KEY  (id),
        KEY post_id (post_id),
        KEY fecha (fecha)
    ) $charset_collate;";

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $sql );
}