<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

// 1. EL SHORTCODE
function mnpn_shortcode_contenedor( $atts ) {
    $atts = shortcode_atts( array( 
        'rango'    => 'trending',
        'offset'   => 0,
        'cantidad' => '',
        'titulo'   => ''
    ), $atts, 'mnp-newsroom-popular-posts' ); // Text Domain se mantiene igual (es el slug del plugin)
    
    $rango  = sanitize_text_field( $atts['rango'] );
    $offset = absint( $atts['offset'] );

    // Defaults
    $titulo_final   = ''; 
    $cantidad_final = 5; 
    $contador_db    = false; 
    $antiguedad_db  = 0; 
    $layout_db      = 'left';

    // CAMBIO TOTAL DE PREFIJO A 'mnpn_' EN LAS OPCIONES
    switch ( $rango ) {
        case 'hoy':
            $titulo_final   = get_option( 'mnpn_hoy_titulo', __( 'Lo más leído hoy', 'mnp-newsroom-popular-posts' ) );
            $cantidad_final = get_option( 'mnpn_hoy_cantidad', 5 );
            $contador_db    = get_option( 'mnpn_hoy_contador' );
            $antiguedad_db  = get_option( 'mnpn_hoy_antiguedad', 2 );
            $layout_db      = get_option( 'mnpn_hoy_layout', 'left' );
            break;
        case 'trending':
            $titulo_final   = get_option( 'mnpn_trend_titulo', __( 'Tendencia Ahora', 'mnp-newsroom-popular-posts' ) );
            $cantidad_final = get_option( 'mnpn_trend_cantidad', 5 );
            $contador_db    = get_option( 'mnpn_trend_contador' );
            $antiguedad_db  = get_option( 'mnpn_trend_antiguedad', 30 );
            $layout_db      = get_option( 'mnpn_trend_layout', 'left' );
            break;
        case 'semana':
            $titulo_final   = get_option( 'mnpn_semana_titulo', __( 'Top Semanal', 'mnp-newsroom-popular-posts' ) );
            $cantidad_final = get_option( 'mnpn_semana_cantidad', 5 );
            $contador_db    = get_option( 'mnpn_semana_contador' );
            $antiguedad_db  = get_option( 'mnpn_semana_antiguedad', 90 );
            $layout_db      = get_option( 'mnpn_semana_layout', 'left' );
            break;
        default:
            $titulo_final = __( 'Más Leídas', 'mnp-newsroom-popular-posts' );
            break;
    }

    if ( ! empty( $atts['cantidad'] ) ) $cantidad_final = absint( $atts['cantidad'] );
    if ( ! empty( $atts['titulo'] ) ) $titulo_final = sanitize_text_field( $atts['titulo'] );

    $mostrar_eye  = ( $contador_db ) ? 'si' : 'no';
    $clase_layout = 'mnpn-layout-' . sanitize_html_class( $layout_db ); // Cambio CSS

    // Salida con Late Escaping estricto y clases CSS actualizadas
    return '
    <div class="mnpn-wrapper ' . esc_attr( $clase_layout ) . '">
        <h3 class="mnpn-widget-title">' . esc_html( $titulo_final ) . '</h3>
        <div class="mnpn-contenedor-noticias" 
             data-cantidad="' . esc_attr( $cantidad_final ) . '"
             data-rango="' . esc_attr( $rango ) . '"
             data-antiguedad="' . esc_attr( $antiguedad_db ) . '"
             data-mostrar-eye="' . esc_attr( $mostrar_eye ) . '"
             data-offset="' . esc_attr( $offset ) . '"> 
            <div class="mnpn-loading">' . esc_html__( 'Cargando...', 'mnp-newsroom-popular-posts' ) . '</div>
        </div>
    </div>';
}
add_shortcode( 'mnpn_populares', 'mnpn_shortcode_contenedor' );

// 2. JAVASCRIPT Y LOCALIZACIÓN
function mnpn_cargar_assets() {
    $is_dev_mode     = get_option( 'mnpn_modo_dev' );
    $version_scripts = $is_dev_mode ? time() : MNPN_VERSION;

    // A. JS Principal
    wp_enqueue_script( 'mnpn-script', MNPN_URL . 'assets/js/mnp-app.js', array( 'jquery' ), $version_scripts, true );
    
    global $post;
    $excluir_actual_setting = get_option( 'mnpn_excluir_actual' ) ? '1' : '0';
    $excluir_id = ( is_single() && get_post_type() === 'post' && $excluir_actual_setting === '1' ) ? $post->ID : 0;
    $post_id_conteo = ( is_single() && get_post_type() === 'post' ) ? $post->ID : 0;

    wp_localize_script( 'mnpn-script', 'mnpn_datos', array(
        'api_url'     => get_rest_url( null, 'mnpn/v1/datos' ),
        'post_id'     => $post_id_conteo,
        'excluir_id'  => $excluir_id,
        'texto_vacio' => get_option( 'mnpn_texto_vacio', __( 'Sin lecturas recientes.', 'mnp-newsroom-popular-posts' ) ),
        'nonce'       => wp_create_nonce( 'wp_rest' )
    ));

    // B. CSS Nuclear (Inline Style Standard)
    $css_base = '
        /* MNP Newsroom Base Styles */
        .mnpn-wrapper { font-family: inherit; margin-bottom: 20px; box-sizing: border-box; }
        .mnpn-loading { opacity: 0.6; padding: 10px; font-size: 0.9em; }
        .mnpn-lista { list-style: none !important; padding: 0 !important; margin: 0 !important; }
        .mnpn-item { display: flex; gap: 10px; margin-bottom: 12px; border-bottom: 1px solid #f5f5f5; padding-bottom: 8px; align-items: flex-start; }
        .mnpn-thumb { width: 90px; flex-shrink: 0; position: relative; }
        .mnpn-thumb img { width: 100%; height: 70px; border-radius: 4px; object-fit: cover; aspect-ratio: unset !important; }
        .mnpn-ranking { position: absolute; top: 0; left: 0; background: #d63638; color: #fff; font-size: 10px; padding: 2px 5px; font-weight: bold; border-radius: 4px 0 4px 0; line-height:1; }
        .mnpn-info { flex-grow: 1; }
        .mnpn-titulo { margin: 0 0 5px 0; font-size: 15px; line-height: 1.3; font-weight: 600; }
        .mnpn-enlace { text-decoration: none; color: inherit; display: flex; gap:10px; width:100%; }
        .mnpn-contador { font-size: 0.8em; color: #999; }
        .mnpn-wrapper.mnpn-layout-right .mnpn-enlace { flex-direction: row-reverse !important; }
        .mnpn-wrapper.mnpn-layout-hidden .mnpn-thumb { display: none !important; }
    ';

    $css_custom = get_option( 'mnpn_css_personalizado' );
    
    wp_register_style( 'mnpn-estilos', false, array(), MNPN_VERSION ); 
    wp_enqueue_style( 'mnpn-estilos' );
    
    // LATE ESCAPING ESTRICTO: wp_strip_all_tags se ejecuta justo en el parámetro de salida
    wp_add_inline_style( 'mnpn-estilos', $css_base . wp_strip_all_tags( $css_custom ) );
}
add_action( 'wp_enqueue_scripts', 'mnpn_cargar_assets' );