<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

function mnpn_agregar_menu() {
    add_options_page( 
        __( 'Ajustes de MNP Newsroom', 'mnp-newsroom-popular-posts' ),
        __( 'Mis Noticias Top', 'mnp-newsroom-popular-posts' ),
        'manage_options', 
        'mnpn-ajustes', // Slug actualizado
        'mnpn_renderizar_admin' // Función callback actualizada
    );
}
add_action( 'admin_menu', 'mnpn_agregar_menu' );

function mnpn_registrar_ajustes() {
    $grupo = 'mnpn_grupo_unico'; // Grupo actualizado

    // Globales - Todo actualizado a 'mnpn_'
    register_setting( $grupo, 'mnpn_dias_limpieza', 'absint' );
    register_setting( $grupo, 'mnpn_texto_vacio', 'sanitize_text_field' );
    register_setting( $grupo, 'mnpn_css_personalizado', 'wp_strip_all_tags' ); // Sanitización mejorada aquí también
    register_setting( $grupo, 'mnpn_excluir_actual', 'absint' );
    register_setting( $grupo, 'mnpn_modo_dev', 'absint' );

    // Hoy
    register_setting( $grupo, 'mnpn_hoy_titulo', 'sanitize_text_field' );
    register_setting( $grupo, 'mnpn_hoy_cantidad', 'absint' );
    register_setting( $grupo, 'mnpn_hoy_contador', 'absint' );
    register_setting( $grupo, 'mnpn_hoy_antiguedad', 'absint' );
    register_setting( $grupo, 'mnpn_hoy_layout', 'sanitize_text_field' );

    // Tendencia
    register_setting( $grupo, 'mnpn_trend_titulo', 'sanitize_text_field' );
    register_setting( $grupo, 'mnpn_trend_cantidad', 'absint' );
    register_setting( $grupo, 'mnpn_trend_contador', 'absint' );
    register_setting( $grupo, 'mnpn_trend_antiguedad', 'absint' );
    register_setting( $grupo, 'mnpn_trend_layout', 'sanitize_text_field' );

    // Semana
    register_setting( $grupo, 'mnpn_semana_titulo', 'sanitize_text_field' );
    register_setting( $grupo, 'mnpn_semana_cantidad', 'absint' );
    register_setting( $grupo, 'mnpn_semana_contador', 'absint' );
    register_setting( $grupo, 'mnpn_semana_antiguedad', 'absint' );
    register_setting( $grupo, 'mnpn_semana_layout', 'sanitize_text_field' );
}
add_action( 'admin_init', 'mnpn_registrar_ajustes' );

function mnpn_admin_assets($hook) {
    // Verificamos el nuevo slug de la página
    if ( 'settings_page_mnpn-ajustes' !== $hook ) return;
    
    wp_enqueue_code_editor( array( 'type' => 'text/css' ) );
    wp_enqueue_script( 'wp-theme-plugin-editor' );
    wp_enqueue_style( 'wp-codemirror' );

    // Script actualizado con nuevos IDs
    $script_admin = "
    jQuery(document).ready(function($) {
        if ($('#mnpn_css_editor').length) { wp.codeEditor.initialize($('#mnpn_css_editor'), { type: 'text/css' }); }
        $('#mnpn-tabs a').click(function(e) {
            e.preventDefault();
            $('#mnpn-tabs a').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            var target = $(this).attr('href');
            $('.mnpn-tab-content').hide();
            $(target).show();
        });
        var hash = window.location.hash;
        if (hash) { $('#mnpn-tabs a[href=\"' + hash + '\"]').click(); }
    });
    ";
    
    wp_add_inline_script( 'wp-theme-plugin-editor', $script_admin );
}
add_action( 'admin_enqueue_scripts', 'mnpn_admin_assets' );

function mnpn_renderizar_admin() {
    $css_default = "/* --- MNP Default Styles --- */
html body .mnpn-wrapper { 
    background: #fff; 
    padding: 15px; 
    border: 1px solid #e0e0e0; 
    border-radius: 8px; 
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important; 
}
/* Agrega tus estilos aquí si lo deseas */";

    ?>
    <div class="wrap">
        <h1><?php esc_html_e( '🚀 MNP Newsroom: Configuración', 'mnp-newsroom-popular-posts' ); ?></h1>
        
        <h2 class="nav-tab-wrapper" id="mnpn-tabs">
            <a href="#tab-global" class="nav-tab nav-tab-active"><?php esc_html_e( '⚙️ Globales & Ayuda', 'mnp-newsroom-popular-posts' ); ?></a>
            <a href="#tab-hoy" class="nav-tab"><?php esc_html_e( '📅 Hoy', 'mnp-newsroom-popular-posts' ); ?></a>
            <a href="#tab-trend" class="nav-tab"><?php esc_html_e( '🔥 Tendencias', 'mnp-newsroom-popular-posts' ); ?></a>
            <a href="#tab-semana" class="nav-tab"><?php esc_html_e( '📆 Semana', 'mnp-newsroom-popular-posts' ); ?></a>
        </h2>

        <form method="post" action="options.php">
            <?php settings_fields( 'mnpn_grupo_unico' ); ?>
            
            <div id="tab-global" class="mnpn-tab-content">
                
                <div style="background:#fff3cd; border:1px solid #ffeeba; padding:15px; margin-bottom:20px; border-radius:5px;">
                    <h3 style="margin-top:0;"><?php esc_html_e( '📚 Guía de Shortcodes', 'mnp-newsroom-popular-posts' ); ?></h3>
                    <p><?php esc_html_e( 'Copia y pega estos códigos. Si no especificas el rango, se mostrará "Tendencias" por defecto.', 'mnp-newsroom-popular-posts' ); ?></p>
                    <table class="widefat fixed" style="background:transparent; border:none; box-shadow:none;">
                        <tbody>
                            <tr>
                                <td><code>rango="..."</code></td>
                                <td><?php echo wp_kses_post( __( 'Elige la lista: <strong>hoy</strong>, <strong>trending</strong> o <strong>semana</strong>.', 'mnp-newsroom-popular-posts' ) ); ?></td>
                                <td><code>[mnpn_populares rango="hoy"]</code></td>
                            </tr>
                            <tr>
                                <td><code>cantidad="X"</code></td>
                                <td><?php esc_html_e( 'Número de noticias a mostrar.', 'mnp-newsroom-popular-posts' ); ?></td>
                                <td><code>[mnpn_populares cantidad="10"]</code></td>
                            </tr>
                            <tr>
                                <td><code>offset="X"</code></td>
                                <td><?php esc_html_e( 'Saltar las primeras X noticias.', 'mnp-newsroom-popular-posts' ); ?></td>
                                <td><code>[mnpn_populares offset="5"]</code></td>
                            </tr>
                            <tr>
                                <td><code>titulo="..."</code></td>
                                <td><?php esc_html_e( 'Cambiar el título del widget.', 'mnp-newsroom-popular-posts' ); ?></td>
                                <td><code>[mnpn_populares titulo="Top"]</code></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <h3><?php esc_html_e( 'Sistema', 'mnp-newsroom-popular-posts' ); ?></h3>
                <table class="form-table">
                    <tr>
                        <th><?php esc_html_e( 'Modo Desarrollador', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <label style="color:#d63638; font-weight:bold;">
                                <input type="checkbox" name="mnpn_modo_dev" value="1" <?php checked( 1, get_option('mnpn_modo_dev'), true ); ?> /> 
                                <?php esc_html_e( '🔥 Activar anti-caché', 'mnp-newsroom-popular-posts' ); ?>
                            </label>
                            <p class="description"><?php esc_html_e( 'Activar si los cambios de CSS no se ven.', 'mnp-newsroom-popular-posts' ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Limpieza Historial', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <?php esc_html_e( 'Borrar registros anteriores a', 'mnp-newsroom-popular-posts' ); ?> 
                            <input type="number" name="mnpn_dias_limpieza" value="<?php echo esc_attr( get_option('mnpn_dias_limpieza', 30) ); ?>" class="small-text" /> 
                            <?php esc_html_e( 'días.', 'mnp-newsroom-popular-posts' ); ?>
                        </td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Excluir Actual', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td><label><input type="checkbox" name="mnpn_excluir_actual" value="1" <?php checked( 1, get_option('mnpn_excluir_actual'), true ); ?> /> <?php esc_html_e( 'No mostrar post actual.', 'mnp-newsroom-popular-posts' ); ?></label></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Mensaje Vacío', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td><input type="text" name="mnpn_texto_vacio" value="<?php echo esc_attr( get_option('mnpn_texto_vacio', __( 'Sin lecturas recientes.', 'mnp-newsroom-popular-posts' ) ) ); ?>" class="regular-text" /></td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><?php esc_html_e( 'CSS Personalizado', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <textarea id="mnpn_css_editor" name="mnpn_css_personalizado" rows="10" class="large-text code"><?php echo esc_textarea( get_option('mnpn_css_personalizado', $css_default) ); ?></textarea>
                        </td>
                    </tr>
                </table>
            </div>

            <div id="tab-hoy" class="mnpn-tab-content" style="display:none;">
                <h3><?php esc_html_e( 'Configuración: HOY', 'mnp-newsroom-popular-posts' ); ?></h3>
                
                <div style="background:#e6f2ff; border-left:4px solid #0073aa; padding:10px; margin-bottom:15px;">
                    <p style="margin:0;"><?php echo wp_kses_post( __( '<strong>💡 Shortcode para esta lista:</strong> <code>[mnpn_populares rango="hoy"]</code>', 'mnp-newsroom-popular-posts' ) ); ?></p>
                </div>

                <table class="form-table">
                    <tr><th><?php esc_html_e( 'Título', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="text" name="mnpn_hoy_titulo" value="<?php echo esc_attr( get_option('mnpn_hoy_titulo', __( 'Lo más leído hoy', 'mnp-newsroom-popular-posts' ) ) ); ?>" class="regular-text" /></td></tr>
                    <tr><th><?php esc_html_e( 'Cantidad', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="number" name="mnpn_hoy_cantidad" value="<?php echo esc_attr( get_option('mnpn_hoy_cantidad', 5) ); ?>" class="small-text" /></td></tr>
                    <tr>
                        <th><?php esc_html_e( 'Antigüedad Máx', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td><input type="number" name="mnpn_hoy_antiguedad" value="<?php echo esc_attr( get_option('mnpn_hoy_antiguedad', 2) ); ?>" class="small-text" /> <?php esc_html_e( 'días.', 'mnp-newsroom-popular-posts' ); ?></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Diseño', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <select name="mnpn_hoy_layout">
                                <option value="left" <?php selected( get_option('mnpn_hoy_layout'), 'left' ); ?>><?php esc_html_e( 'Imagen Izquierda', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="right" <?php selected( get_option('mnpn_hoy_layout'), 'right' ); ?>><?php esc_html_e( 'Imagen Derecha', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="hidden" <?php selected( get_option('mnpn_hoy_layout'), 'hidden' ); ?>><?php esc_html_e( 'Sin Imagen', 'mnp-newsroom-popular-posts' ); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Visitas', 'mnp-newsroom-popular-posts' ); ?></th><td><label><input type="checkbox" name="mnpn_hoy_contador" value="1" <?php checked( 1, get_option('mnpn_hoy_contador'), true ); ?> /> <?php esc_html_e( 'Mostrar badge', 'mnp-newsroom-popular-posts' ); ?></label></td></tr>
                </table>
            </div>

            <div id="tab-trend" class="mnpn-tab-content" style="display:none;">
                <h3><?php esc_html_e( 'Configuración: TENDENCIAS', 'mnp-newsroom-popular-posts' ); ?></h3>

                <div style="background:#e6f2ff; border-left:4px solid #0073aa; padding:10px; margin-bottom:15px;">
                    <p style="margin:0;"><?php echo wp_kses_post( __( '<strong>💡 Shortcode para esta lista:</strong> <code>[mnpn_populares rango="trending"]</code> (o simplemente <code>[mnpn_populares]</code>)', 'mnp-newsroom-popular-posts' ) ); ?></p>
                </div>

                <table class="form-table">
                    <tr><th><?php esc_html_e( 'Título', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="text" name="mnpn_trend_titulo" value="<?php echo esc_attr( get_option('mnpn_trend_titulo', __( 'Tendencia Ahora', 'mnp-newsroom-popular-posts' ) ) ); ?>" class="regular-text" /></td></tr>
                    <tr><th><?php esc_html_e( 'Cantidad', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="number" name="mnpn_trend_cantidad" value="<?php echo esc_attr( get_option('mnpn_trend_cantidad', 5) ); ?>" class="small-text" /></td></tr>
                    <tr>
                        <th><?php esc_html_e( 'Antigüedad Máx', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td><input type="number" name="mnpn_trend_antiguedad" value="<?php echo esc_attr( get_option('mnpn_trend_antiguedad', 30) ); ?>" class="small-text" /> <?php esc_html_e( 'días.', 'mnp-newsroom-popular-posts' ); ?></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Diseño', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <select name="mnpn_trend_layout">
                                <option value="left" <?php selected( get_option('mnpn_trend_layout'), 'left' ); ?>><?php esc_html_e( 'Imagen Izquierda', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="right" <?php selected( get_option('mnpn_trend_layout'), 'right' ); ?>><?php esc_html_e( 'Imagen Derecha', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="hidden" <?php selected( get_option('mnpn_trend_layout'), 'hidden' ); ?>><?php esc_html_e( 'Sin Imagen', 'mnp-newsroom-popular-posts' ); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Visitas', 'mnp-newsroom-popular-posts' ); ?></th><td><label><input type="checkbox" name="mnpn_trend_contador" value="1" <?php checked( 1, get_option('mnpn_trend_contador'), true ); ?> /> <?php esc_html_e( 'Mostrar badge', 'mnp-newsroom-popular-posts' ); ?></label></td></tr>
                </table>
            </div>

            <div id="tab-semana" class="mnpn-tab-content" style="display:none;">
                <h3><?php esc_html_e( 'Configuración: SEMANA', 'mnp-newsroom-popular-posts' ); ?></h3>

                <div style="background:#e6f2ff; border-left:4px solid #0073aa; padding:10px; margin-bottom:15px;">
                    <p style="margin:0;"><?php echo wp_kses_post( __( '<strong>💡 Shortcode para esta lista:</strong> <code>[mnpn_populares rango="semana"]</code>', 'mnp-newsroom-popular-posts' ) ); ?></p>
                </div>

                <table class="form-table">
                    <tr><th><?php esc_html_e( 'Título', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="text" name="mnpn_semana_titulo" value="<?php echo esc_attr( get_option('mnpn_semana_titulo', __( 'Top Semanal', 'mnp-newsroom-popular-posts' ) ) ); ?>" class="regular-text" /></td></tr>
                    <tr><th><?php esc_html_e( 'Cantidad', 'mnp-newsroom-popular-posts' ); ?></th><td><input type="number" name="mnpn_semana_cantidad" value="<?php echo esc_attr( get_option('mnpn_semana_cantidad', 5) ); ?>" class="small-text" /></td></tr>
                    <tr>
                        <th><?php esc_html_e( 'Antigüedad Máx', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td><input type="number" name="mnpn_semana_antiguedad" value="<?php echo esc_attr( get_option('mnpn_semana_antiguedad', 90) ); ?>" class="small-text" /> <?php esc_html_e( 'días.', 'mnp-newsroom-popular-posts' ); ?></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Diseño', 'mnp-newsroom-popular-posts' ); ?></th>
                        <td>
                            <select name="mnpn_semana_layout">
                                <option value="left" <?php selected( get_option('mnpn_semana_layout'), 'left' ); ?>><?php esc_html_e( 'Imagen Izquierda', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="right" <?php selected( get_option('mnpn_semana_layout'), 'right' ); ?>><?php esc_html_e( 'Imagen Derecha', 'mnp-newsroom-popular-posts' ); ?></option>
                                <option value="hidden" <?php selected( get_option('mnpn_semana_layout'), 'hidden' ); ?>><?php esc_html_e( 'Sin Imagen', 'mnp-newsroom-popular-posts' ); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Visitas', 'mnp-newsroom-popular-posts' ); ?></th><td><label><input type="checkbox" name="mnpn_semana_contador" value="1" <?php checked( 1, get_option('mnpn_semana_contador'), true ); ?> /> <?php esc_html_e( 'Mostrar badge', 'mnp-newsroom-popular-posts' ); ?></label></td></tr>
                </table>
            </div>
            
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}