jQuery(document).ready(function ($) {
    
    // Función auxiliar para escapar HTML (Seguridad XSS)
    function escapeHtml(text) {
        if (!text) return text;
        return text
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    // 1. Configuración Global: Enviar siempre el Nonce en la cabecera
    // IMPORTANTE: Variable actualizada a 'mnpn_datos'
    $.ajaxSetup({
        beforeSend: function (xhr) {
            xhr.setRequestHeader('X-WP-Nonce', mnpn_datos.nonce);
        }
    });

    // 2. Cargar Noticias (Widget)
    // Selector actualizado a la nueva clase '.mnpn-contenedor-noticias'
    $('.mnpn-contenedor-noticias').each(function () {
        var $contenedor = $(this);
        var rango = $contenedor.data('rango');
        var cantidad = $contenedor.data('cantidad');
        var antiguedad = $contenedor.data('antiguedad');
        var mostrarEye = $contenedor.data('mostrar-eye');
        var offset = $contenedor.data('offset') || 0;

        // Variables actualizadas desde 'mnpn_datos'
        var apiUrl = mnpn_datos.api_url;
        var excluirId = mnpn_datos.excluir_id;

        $.ajax({
            url: apiUrl,
            method: 'GET',
            data: {
                rango: rango,
                cantidad: cantidad + offset,
                excluir: excluirId,
                antiguedad: antiguedad
            },
            success: function (response) {
                if (response && response.length > 0) {
                    // Clases actualizadas a 'mnpn-'
                    var html = '<ul class="mnpn-lista">';
                    var mostrados = 0;
                    var index = 0;

                    $.each(response, function (i, item) {
                        if (index < offset) { index++; return true; }
                        if (mostrados >= cantidad) { return false; }

                        // Escapamos los datos antes de usarlos
                        var tituloSeguro = escapeHtml(item.titulo);
                        var enlaceSeguro = item.enlace; 
                        var imagenSegura = item.imagen; 

                        html += '<li class="mnpn-item">';
                        html += '<a href="' + enlaceSeguro + '" class="mnpn-enlace">';

                        if (imagenSegura && imagenSegura !== "") {
                            html += '<div class="mnpn-thumb">';
                            html += '<span class="mnpn-ranking">#' + (index + 1) + '</span>';
                            html += '<img src="' + imagenSegura + '" alt="' + tituloSeguro + '" loading="lazy">';
                            html += '</div>';
                        } else {
                            html += '<div class="mnpn-thumb">';
                            html += '<span class="mnpn-ranking">#' + (index + 1) + '</span>';
                            html += '</div>';
                        }

                        html += '<div class="mnpn-info">';
                        html += '<h4 class="mnpn-titulo">' + tituloSeguro + '</h4>';

                        if (mostrarEye === 'si') {
                            html += '<span class="mnpn-contador" title="Lecturas estimadas">';
                            html += '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right:3px; vertical-align:middle;"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>';
                            html += parseInt(item.visitas); 
                            html += '</span>';
                        }

                        html += '</div>';
                        html += '</a>';
                        html += '</li>';

                        mostrados++;
                        index++;
                    });

                    html += '</ul>';

                    if (mostrados === 0) {
                         // Variable actualizada y clase actualizada
                         $contenedor.html('<p class="mnpn-vacio">' + mnpn_datos.texto_vacio + '</p>');
                    } else {
                        $contenedor.html(html);
                    }
                } else {
                    $contenedor.html('<p class="mnpn-vacio">' + mnpn_datos.texto_vacio + '</p>');
                }
            },
            error: function () {
                $contenedor.html('<p class="mnpn-error">Error al cargar noticias.</p>');
            }
        });
    });
    
    // 3. Registrar Visita (Con retardo de 3s para evitar rebotes)
    // Variable actualizada
    if (mnpn_datos.post_id > 0) {
        setTimeout(function() {
            $.ajax({
                // URL actualizada (la API ya responde en mnpn/v1/contar)
                url: mnpn_datos.api_url.replace('/datos', '/contar'),
                method: 'POST',
                data: { id: mnpn_datos.post_id }
            });
        }, 3000);
    }
});