# Minutemailer WordPress Plugin

Easily add Minutemailer subscription forms to your WordPress site with a customizable Gutenberg block.

## Description

Minutemailer for WordPress allows you to seamlessly integrate Minutemailer subscription forms into your WordPress website. This plugin provides a Gutenberg block that makes it easy to add beautiful, customizable subscription forms anywhere on your site.

### Key Features

- **Gutenberg Block Integration** - Add subscription forms using the familiar block editor
- **Customizable Forms** - Configure form fields, labels, button styles, and messaging
- **Optional Name Field** - Choose whether to collect subscriber names in addition to email addresses
- **Success Messages** - Customize confirmation messages after successful subscriptions
- **Minutemailer API Integration** - Direct connection to your Minutemailer account and contact lists
- **Responsive Design** - Forms look great on all devices
- **Easy Setup** - Simple configuration with your Minutemailer API token

## Development Setup

### Prerequisites

- Node.js (version 20 or higher)
- npm or yarn
- Docker (for wp-env local environment)

### Installation for Development

1. Clone the repository:
   ```bash
   git clone https://github.com/minutemailer/minutemailer-wp.git
   cd minutemailer-wp
   ```

2. Install dependencies:
   ```bash
   npm install
   ```

3. Start the local WordPress environment using wp-env:
   ```bash
   npx @wordpress/env start
   ```
   This will create a local WordPress instance at http://localhost:8888 with the plugin automatically installed and activated.

### Development Commands

The project uses `@wordpress/scripts` for development and build processes:

#### Start Development Server
```bash
npm run start
```
Starts the development server with hot reloading for block development.

#### Build for Production
```bash
npm run build
```
Creates optimized production builds in the `build/` directory.

#### Code Quality

**Format Code:**
```bash
npm run format
```

**Lint JavaScript:**
```bash
npm run lint:js
```

**Lint CSS/SCSS:**
```bash
npm run lint:css
```

#### Package Plugin
```bash
npm run plugin-zip
```
Creates a distributable ZIP file of the plugin.

#### Update Dependencies
```bash
npm run packages-update
```
Updates WordPress script packages to their latest versions.

#### WordPress Environment (wp-env)

**Start Environment:**
```bash
npx @wordpress/env start
```
Starts the local WordPress environment at http://localhost:8888

**Stop Environment:**
```bash
npx @wordpress/env stop
```
Stops the local WordPress environment.

**Reset Environment:**
```bash
npx @wordpress/env clean
```
Removes the local WordPress environment and all data.

## Project Structure

```
minutemailer-wp/
├── src/
│   └── minutemailer-wp/          # Block source files
│       ├── block.json            # Block configuration
│       ├── index.js              # Block registration
│       ├── edit.js               # Block editor component
│       ├── save.js               # Block save component
│       ├── view.js               # Frontend JavaScript
│       ├── style.scss            # Frontend styles
│       └── editor.scss           # Editor styles
├── includes/                     # PHP classes and functionality
├── languages/                    # Translation files
├── assets/                       # Static assets
├── build/                        # Compiled assets (generated)
├── minutemailer.php              # Main plugin file
├── package.json                  # js dependencies and scripts
└── readme.txt                    # WordPress plugin readme
```

## Installation for Users

1. Upload the plugin files to `/wp-content/plugins/minutemailer-wp/` directory, or install through the WordPress plugins screen.
2. Activate the plugin through the 'Plugins' screen in WordPress.
3. Go to the 'Minutemailer' settings page in your WordPress admin menu.
4. Enter your Minutemailer API token (found at https://app.minutemailer.com/u/settings/api).
5. Add the Minutemailer Subscription Form block to any page or post.

## Configuration

### API Token Setup

1. Log in to your Minutemailer account
2. Navigate to Settings > API at https://app.minutemailer.com/u/settings/api
3. Generate or copy your API token
4. Enter the token in the WordPress admin under Minutemailer settings

### Block Usage

1. In the WordPress block editor, search for "Minutemailer"
2. Add the Minutemailer Subscription Form block
3. Configure the form settings in the block sidebar:
   - Headline and description text
   - Form field labels
   - Button styling and text
   - Success messages
   - Name field visibility

## Contributing

### Bug Reports

Found a bug? Please report it in our [GitHub Issues](https://github.com/minutemailer/minutemailer-wp/issues).

### Development Workflow

1. Fork the repository
2. Create a feature branch: `git checkout -b feature/your-feature-name`
3. Make your changes
4. Run tests and linting: `npm run lint:js && npm run lint:css`
5. Format your code: `npm run format`
6. Commit your changes: `git commit -am 'Add some feature'`
7. Push to the branch: `git push origin feature/your-feature-name`
8. Submit a pull request

### Coding Standards

- Follow WordPress coding standards for PHP
- Use ESLint and Prettier for JavaScript formatting
- Follow WordPress block development best practices
- Write clear, descriptive commit messages

## License

This project is licensed under the GPL-2.0-or-later License. See the [LICENSE](https://www.gnu.org/licenses/gpl-2.0.html) file for details.

## Links

- [Minutemailer Website](https://minutemailer.com)
- [Minutemailer App](https://app.minutemailer.com)
- [WordPress Plugin Directory](https://wordpress.org/plugins/minutemailer/)
- [GitHub Repository](https://github.com/minutemailer/minutemailer-wp)

## Support

For support questions, please use the [WordPress.org support forums](https://wordpress.org/support/plugin/minutemailer/) or contact us through the Minutemailer app.
